/*
 * XXXX 
 *
 * Fecha 14/05/2007
 * 
 *  
 */
 
package com.ejie.p06b.servlet.presentacion.corredores;

import java.util.ArrayList;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejie.p06b.datatype.logic.P06BCorredor;
import com.ejie.p06b.datatype.logic.P06BCorredorListasAux;
import com.ejie.p06b.datatype.logic.P06BError;
import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.datatype.model.P06B22T00Datatype;
import com.ejie.p06b.datatype.model.P06B25T00Datatype;
import com.ejie.p06b.datatype.model.P06B26T00Datatype;
import com.ejie.p06b.datatype.model.P06B27T00Datatype;
import com.ejie.p06b.datatype.model.P06B28T00Datatype;
import com.ejie.p06b.datatype.model.P06B29T00Datatype;
import com.ejie.p06b.datatype.model.P06B30T00Datatype;
import com.ejie.p06b.datatype.model.P06B24T00Datatype;
import com.ejie.p06b.datatype.model.P06B60T00Datatype;
import com.ejie.p06b.datatype.model.P06B61T00Datatype;
import com.ejie.p06b.datatype.model.P06B64T00Datatype;
import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.general.P06BPaginas;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.manager.P06BGeneralManager;
import com.ejie.p06b.p06bMediadoresSegurosEJB.P06BMediadoresSegurosEJB;
import com.ejie.p06b.p06bMediadoresSegurosEJB.P06BMediadoresSegurosEJBHome;

import com.ejie.p06b.servlet.P06BServletGenerico;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.P06BFieldsValidations;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.util.P06BResources;

/**
 *  Esta clase gestiona las peticiones HTTP de la aplicacin.
 */
public class P06BCorredorModificarServlet extends P06BServletGenerico 
{

	//Cambia de idioma en la sesin -> Perfil
	public void ejecutar(HttpServletRequest request, HttpServletResponse response) {
		try {
			if(request.getParameter("accion")==null || request.getParameter("accion").equals("")){
				//Cuando damos al MODIFICAR (un corredor en la aplicacin) llego a este punto.
				//Por tanto debo resetear todas las variables de sesin de la aplicacin
				//para optimizar espacio. No borro los filtros.
				//Puede ser que haya navegado sin pasar por el men
				this.deleteTempFromSession(request,P06BConstantes.P06B_VAR_TEMP_FILTRO);
				//Vengo por primera vez al modificar (sin num. exp. seleccionado)
				//o si he quitado el valor al campo num. Exp. -> ""
			}else if (request.getParameter("accion").equals("FCA")){
				//IMPORTANTE: A diferencia del NUEVO, en este caso tengo la informacin de la JSP en un ATRIBUTO
				//de la request. Si enviara al servlet de FCA's debera pasar los parmetros al obj 
				// atributo correspondiente. Esto ya lo tengo aqu echo para cuando se produce un error 
				//en la validacin de un campo.
				this.actualizarListas(request);
				this.obtenerFCAs(request, response);
				this.fromParamToSession(request,response);
			}else if (request.getParameter("accion").equals("cambiaDefensaAtencionCliente")){
				//Se recuperan de la BD los datos de DefensaAtencion Cliente. Lo dems como est.
				this.actualizarListas(request);
				this.inicializarListaDefCliente(request);
				this.inicializarListaDepAtCliente(request);
				this.obtenerFCAs(request, response);
				this.fromParamToSession(request,response);
			}else if (request.getParameter("accion").equals("cambio")){
				//Obtengo los valores de la BD y los meto en la request
				if(this.obtener(request,response)){
					this.obtenerFCAs2(request,response);
				}
			}else if (request.getParameter("accion").equals("tablaChange")){
				this.actualizarListas(request);
				String tabla = (request.getParameter("tablaChange")==null)?"":request.getParameter("tablaChange");
				if(tabla.equals("tablaSocios")){
					this.anadirToListaSocios(request);
				}else if(tabla.equals("tablaAdministradores")){
					this.anadirToListaAdministradores(request);
				}else if(tabla.equals("tablaOrganos")){
					this.anadirToListaOrganos(request);
				}else if(tabla.equals("tablaSociosIndirec")){
					this.anadirToListaSociosIndirec(request);
				}else if(tabla.equals("tablaAuxExternos")){
					this.anadirToListaAuxExternos(request);
				}else if(tabla.equals("tablaDirecTec")){
					this.anadirToListaDirecTec(request);
				}else if(tabla.equals("tablaOtrosDirec")){
					this.anadirToListaOtrosDirec(request);
				}else if(tabla.equals("tablaSucursales")){
					this.anadirToListaSucursales(request);
				}else if(tabla.equals("tablaDefCliente")){
					this.anadirToListaDefCliente(request);
				}else if(tabla.equals("tablaPFDefCliente")){
					this.anadirToListaPFDefCliente(request);
				}else if(tabla.equals("tablaDepAtCliente")){
					this.anadirToListaDepAtCliente(request);
				}else if(tabla.equals("tablaPFDepAtCliente")){
					this.anadirToListaPFDepAtCliente(request);
				}else if(tabla.equals("tablaRespDepAtCliente")){
					this.anadirToListaRespDepAtCliente(request);
				}else if(tabla.equals("tablaEVs")){
					this.anadirToListaEVs(request);
				}
				
				this.obtenerFCAs(request, response);
				this.fromParamToSession(request,response);
			}else if (request.getParameter("accion").equals("tablaDelete")){
				this.actualizarListas(request);
				String tabla = (request.getParameter("tablaChange")==null)?"":request.getParameter("tablaChange");
				if(tabla.equals("tablaSocios")){
					this.eliminarFromListaSocios(request);
				}else if(tabla.equals("tablaAdministradores")){
					this.eliminarFromListaAdministradores(request);
				}else if(tabla.equals("tablaOrganos")){
					this.eliminarFromListaOrganos(request);
				}else if(tabla.equals("tablaSociosIndirec")){
					this.eliminarFromListaSociosIndirec(request);
				}else if(tabla.equals("tablaAuxExternos")){
					this.eliminarFromListaAuxExternos(request);
				}else if(tabla.equals("tablaDirecTec")){
					this.eliminarFromListaDirecTec(request);
				}else if(tabla.equals("tablaOtrosDirec")){
					this.eliminarFromListaOtrosDirec(request);					
				}else if(tabla.equals("tablaSucursales")){
					this.eliminarFromListaSucursales(request);
				}else if(tabla.equals("tablaDefCliente")){
					this.eliminarFromListaDefCliente(request);
				}else if(tabla.equals("tablaPFDefCliente")){
					this.eliminarFromListaPFDefCliente(request);
				}else if(tabla.equals("tablaDepAtCliente")){
					this.eliminarFromListaDepAtCliente(request);
				}else if(tabla.equals("tablaPFDepAtCliente")){
					this.eliminarFromListaPFDepAtCliente(request);
				}else if(tabla.equals("tablaRespDepAtCliente")){
					this.eliminarFromListaRespDepAtCliente(request);
				}else if(tabla.equals("tablaEVs")){
					this.eliminarFromListaEVs(request);
				}
				
				this.obtenerFCAs(request, response);
				this.fromParamToSession(request,response);
			}else{//en este else entrar si la accion es modificar o adjuntarDocsEnModif
				this.actualizarListas(request);
				//Ha dado a Guardar -> accion = "guardar"
				
				
				
//		        P06B64T00Datatype datosAtencionPeticionEnRevision = null;
//				boolean bCargaIncorporarModTramitagune = false;
				String sObjetivo = (String)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"objetivo"+P06BConstantes.P06B_VAR_TEMP_FILTRO);
//		        if (sObjetivo!= null && sObjetivo.equals(((Integer)P06BConstantes.P06B_BUSQCORR_TRAMITEPENDIENTE_INCORPORARMODTRAMITAGUNE).toString())){
//		        	bCargaIncorporarModTramitagune = true;	        		
//					int nCorrelAtencionPeticionEnRevision = -1;
//					nCorrelAtencionPeticionEnRevision = P06BCorredoresManager.getInstance().selectCorrelAtencionPeticionEnRevision(request.getParameter("Expedi"));
//					datosAtencionPeticionEnRevision = P06BCorredoresManager.getInstance().selectDatosAtencPeticTramitagune(nCorrelAtencionPeticionEnRevision);
//		        }
//				
//				request.setAttribute("datosAtencionPeticionEnRevision", datosAtencionPeticionEnRevision);
				
				
				//1. Valido los campos
				if(this.validate(request,response)){
					//2. Guardo el resultado en BD
	        		String estadoAntiguo = P06BCorredoresManager.getInstance().selectEstadoCorredor(request.getParameter("Expedi").toUpperCase());
	        		byte estadoAtencionPeticion = -1;
	        		if (estadoAntiguo.equals(P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_ALTA)){
	        			if (request.getParameter("Estado").equals(P06BConstantes.P06B_CORREDORES_ESTADO_ALTA_RECHAZADA)){
	        				estadoAtencionPeticion = P06BConstantes.P06B_AP_ESTADO_RECHAZADA;
	        			}else if (request.getParameter("Estado").equals(P06BConstantes.P06B_CORREDORES_ESTADO_ALTA)){
	        				estadoAtencionPeticion = P06BConstantes.P06B_AP_ESTADO_APROBADA;
	        			}	
	        		}else if (estadoAntiguo.equals(P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_BAJA)){
	        			if (request.getParameter("Estado").equals(P06BConstantes.P06B_CORREDORES_ESTADO_ALTA)){
	        				estadoAtencionPeticion = P06BConstantes.P06B_AP_ESTADO_RECHAZADA;
	        			}else if (request.getParameter("Estado").equals(P06BConstantes.P06B_CORREDORES_ESTADO_BAJA)){
	        				estadoAtencionPeticion = P06BConstantes.P06B_AP_ESTADO_APROBADA;
	        			}	
	        		}
	        		
	        		
	        		String expediente = this.update(request,response);
					
					if (request.getParameter("accion").equals("adjuntarDocsEnModif")){
						//Si la accion es adjuntarDocsEnModif, redirijir al servlet de adjuntar documentos o ficheros
						forward (request, response, P06BPaginas.P06B_JSP_SERVLETADJUNTARFICHERO+"?expediente="+expediente);
					}else if (sObjetivo!= null && sObjetivo.equals(((Integer)P06BConstantes.P06B_BUSQCORR_TRAMITEPENDIENTE_INCORPORARMODTRAMITAGUNE).toString())){
						forward (request, response, P06BPaginas.P06B_JSP_SERVLETCORREDORLISTADO);
					}else{
						P06B64T00Datatype datosAtencionPeticionEnRevisionAux = (P06B64T00Datatype)request.getSession().getAttribute("AtencionPeticionEnRevision");
						if (datosAtencionPeticionEnRevisionAux != null){
							request.getSession().removeAttribute("AtencionPeticionEnRevision");
							forward (request, response, P06BPaginas.P06B_JSP_SERVLETATENCIONPETICIONESLISTADO);
						}else if (estadoAtencionPeticion!=-1){
								forward (request, response, P06BPaginas.P06B_JSP_SERVLETCORREDORLISTADO);
						}else{
								//3. Sino es que la accion es modificar, sacar Mensaje de Guardado correcto
								forward (request, response, P06BPaginas.P06B_JSP_CORREDOR_MODIFICADO+"?expediente="+expediente);									
						}
					}
					
					return;
				}else{
					//Recalculamos las combos provincia, municipio, localidad y CP
					//CDIGO IDNTICO A: com.ejie.p06b.servlet.comun.P06BFCAServlet
					this.obtenerFCAs(request, response);
					this.fromParamToSession(request,response);
				}
			}
			//Redireccionamos a la pgina de Mto Corredor - Modificaciones
			forward (request, response, P06BPaginas.P06B_JSP_CORREDOR_MODIFICAR);
		}catch (Exception e){
	      	manejarErrores (request, response, e);
	        return;
	    }
	}
	
	//Recogemos las listas de la pantalla y se actualizan todas.
	private void actualizarListas (HttpServletRequest request) throws Exception {
		this.actualizarListaSocios(request);
		this.actualizarListaSociosIndirec(request);
		this.actualizarListaAuxExternos(request);
		this.actualizarListaAdministradores(request);
		this.actualizarListaOrganos(request);
		this.actualizarListaDirecTec(request);
		this.actualizarListaOtrosDirec(request);
		this.actualizarListaSucursales(request);
		this.actualizarListaDefCliente(request);
		this.actualizarListaDepAtCliente(request);
		this.actualizarListaEVs(request);
	}
	
	//SOCIOS
	//Recogemos la lista de socios y las actualizamos con los nuevos valores
	private void actualizarListaSocios (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un socio
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B22T00Datatype obj = null;
		int numSocios = objListas.getListaSocios().size();
//		objListas.getListaSocios().clear();
		int z=0;
		for(z=0;z<numSocios;z++){
//			obj = new P06B22T00Datatype();
			obj = (P06B22T00Datatype)objListas.getListaSocios().get(z);
			obj.setNExpediente(z+"");
			obj.setTipo((request.getParameter("tipo_socio_"+z)==null)?"":request.getParameter("tipo_socio_"+z));
			obj.setIdentificador((request.getParameter("identif_socio_"+z)==null)?"":request.getParameter("identif_socio_"+z));
			obj.setTipo1((request.getParameter("tipo1_socio_"+z)==null)?"":request.getParameter("tipo1_socio_"+z));
			obj.setRazSoc((request.getParameter("razsoc_socio_"+z)==null)?"":request.getParameter("razsoc_socio_"+z));
			obj.setNombre((request.getParameter("nombre_socio_"+z)==null)?"":request.getParameter("nombre_socio_"+z));
			obj.setApe1((request.getParameter("ape1_socio_"+z)==null)?"":request.getParameter("ape1_socio_"+z));
			obj.setApe2((request.getParameter("ape2_socio_"+z)==null)?"":request.getParameter("ape2_socio_"+z));
			obj.setDomici((request.getParameter("domici_socio_"+z)==null)?"":request.getParameter("domici_socio_"+z));
			obj.setCodmun((request.getParameter("codmun_socio_"+z)==null)?"":request.getParameter("codmun_socio_"+z));
			obj.setLocali((request.getParameter("locali_socio_"+z)==null)?"":request.getParameter("locali_socio_"+z));
			obj.setCodpro((request.getParameter("codpro_socio_"+z)==null)?"":request.getParameter("codpro_socio_"+z));
			obj.setCodpst((request.getParameter("codpst_socio_"+z)==null)?"":request.getParameter("codpst_socio_"+z));
			obj.setFecAlta((request.getParameter("fAlta_socio_"+z)==null)?"":request.getParameter("fAlta_socio_"+z));
			obj.setFecBaja((request.getParameter("fBaja_socio_"+z)==null)?"":request.getParameter("fBaja_socio_"+z));
			obj.setParticipa((request.getParameter("participa_socio_"+z)==null)?"":request.getParameter("participa_socio_"+z));
			obj.setIdRep((request.getParameter("idrep_socio_"+z)==null)?"":request.getParameter("idrep_socio_"+z));
			obj.setNomRep((request.getParameter("nomrep_socio_"+z)==null)?"":request.getParameter("nomrep_socio_"+z));
			if (request.getParameter("operacion_socio_"+z)!=null){
				obj.setOperacion(Integer.parseInt(request.getParameter("operacion_socio_"+z)));				
			}
			if (request.getParameter("aprobado_socio_"+z)!=null){
				obj.setAprobado(Integer.parseInt(request.getParameter("aprobado_socio_"+z)));				
			}
			//Aprobamos todo
			obj.setAprobado(1);				
//			objListas.getListaSocios().add(obj);
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//EVS
	//Recogemos la lista de socios y las actualizamos con los nuevos valores
	private void actualizarListaEVs (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un socio
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B61T00Datatype obj = null;
		int numEVs = objListas.getListaEVs().size();
//		objListas.getListaEVs().clear();
		int z=0;
		for(z=0;z<numEVs;z++){
//			obj = new P06B61T00Datatype();
			obj = (P06B61T00Datatype)objListas.getListaEVs().get(z);
			obj.setExpedi(z+"");
			obj.setCif((request.getParameter("cif_ev_"+z)==null)?"":request.getParameter("cif_ev_"+z));
			obj.setEntidad((request.getParameter("entidad_ev_"+z)==null)?"":request.getParameter("entidad_ev_"+z));
			obj.setCalle((request.getParameter("calle_ev_"+z)==null)?"":request.getParameter("calle_ev_"+z));
			obj.setPortal((request.getParameter("portal_ev_"+z)==null)?"":request.getParameter("portal_ev_"+z));
			obj.setPiso((request.getParameter("piso_ev_"+z)==null)?"":request.getParameter("piso_ev_"+z));
			obj.setLetra((request.getParameter("letra_ev_"+z)==null)?"":request.getParameter("letra_ev_"+z));
			obj.setCodpro((request.getParameter("codpro_ev_"+z)==null)?"":request.getParameter("codpro_ev_"+z));
			obj.setCodmun((request.getParameter("codmun_ev_"+z)==null)?"":request.getParameter("codmun_ev_"+z));
			obj.setLocali((request.getParameter("locali_ev_"+z)==null)?"":request.getParameter("locali_ev_"+z));
			obj.setCodpst((request.getParameter("codpst_ev_"+z)==null)?"":request.getParameter("codpst_ev_"+z));
			obj.setClavecat((request.getParameter("claveCat_ev_"+z)==null)?"":request.getParameter("claveCat_ev_"+z));
			obj.setFhInscrip((request.getParameter("fhInscrip_ev_"+z)==null)?"":request.getParameter("fhInscrip_ev_"+z));
			if (request.getParameter("operacion_ev_"+z)!=null){
				obj.setOperacion(Integer.parseInt(request.getParameter("operacion_ev_"+z)));				
			}
			if (request.getParameter("aprobado_ev_"+z)!=null){
				obj.setAprobado(Integer.parseInt(request.getParameter("aprobado_ev_"+z)));				
			}
			//Aprobamos todo
			obj.setAprobado(1);				
			if (request.getParameter("altabaja_ev_"+z)!=null){
				obj.setAltaBaja(Byte.parseByte(request.getParameter("altabaja_ev_"+z)));				
			}
//			objListas.getListaEVs().add(obj);
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de socios y las actualizamos con los nuevos valores
	private void anadirToListaSocios (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un socio
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B22T00Datatype obj = null;
		int numSocios = objListas.getListaSocios().size();
		objListas.getListaSocios().clear();
		int z=0;
		for(z=0;z<numSocios;z++){
			obj = new P06B22T00Datatype();
			
			obj.setNExpediente(z+"");
			obj.setTipo((request.getParameter("tipo_socio_"+z)==null)?"":request.getParameter("tipo_socio_"+z));
			obj.setIdentificador((request.getParameter("identif_socio_"+z)==null)?"":request.getParameter("identif_socio_"+z));
			obj.setTipo1((request.getParameter("tipo1_socio_"+z)==null)?"":request.getParameter("tipo1_socio_"+z));
			obj.setRazSoc((request.getParameter("razsoc_socio_"+z)==null)?"":request.getParameter("razsoc_socio_"+z));
			obj.setNombre((request.getParameter("nombre_socio_"+z)==null)?"":request.getParameter("nombre_socio_"+z));
			obj.setApe1((request.getParameter("ape1_socio_"+z)==null)?"":request.getParameter("ape1_socio_"+z));
			obj.setApe2((request.getParameter("ape2_socio_"+z)==null)?"":request.getParameter("ape2_socio_"+z));
			obj.setDomici((request.getParameter("domici_socio_"+z)==null)?"":request.getParameter("domici_socio_"+z));
			obj.setCodmun((request.getParameter("codmun_socio_"+z)==null)?"":request.getParameter("codmun_socio_"+z));
			obj.setLocali((request.getParameter("locali_socio_"+z)==null)?"":request.getParameter("locali_socio_"+z));
			obj.setCodpro((request.getParameter("codpro_socio_"+z)==null)?"":request.getParameter("codpro_socio_"+z));
			obj.setCodpst((request.getParameter("codpst_socio_"+z)==null)?"":request.getParameter("codpst_socio_"+z));
			obj.setFecAlta((request.getParameter("fAlta_socio_"+z)==null)?"":request.getParameter("fAlta_socio_"+z));
			obj.setFecBaja((request.getParameter("fBaja_socio_"+z)==null)?"":request.getParameter("fBaja_socio_"+z));
			obj.setParticipa((request.getParameter("participa_socio_"+z)==null)?"":request.getParameter("participa_socio_"+z));
			obj.setIdRep((request.getParameter("idrep_socio_"+z)==null)?"":request.getParameter("idrep_socio_"+z));
			obj.setNomRep((request.getParameter("nomrep_socio_"+z)==null)?"":request.getParameter("nomrep_socio_"+z));
		
			objListas.getListaSocios().add(obj);
		}
		obj = new P06B22T00Datatype();		
		obj.setNExpediente((z+1)+"");
		obj.setTipo("");
		obj.setIdentificador("");
		obj.setTipo1("");
		obj.setRazSoc("");
		obj.setNombre("");
		obj.setApe1("");
		obj.setApe2("");
		obj.setDomici("");
		obj.setCodmun("");
		obj.setLocali("");
		obj.setCodpro("");
		obj.setCodpst("");
		obj.setFecAlta("");
		obj.setFecBaja("");
		obj.setParticipa("");
		objListas.getListaSocios().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de socios y las actualizamos con los nuevos valores
	private void anadirToListaEVs (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un socio
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B61T00Datatype obj = null;
		int numEVs = objListas.getListaEVs().size();
		objListas.getListaEVs().clear();
		int z=0;
		for(z=0;z<numEVs;z++){
			obj = new P06B61T00Datatype();
			obj.setExpedi(z+"");
			obj.setCif((request.getParameter("cif_ev_"+z)==null)?"":request.getParameter("cif_ev_"+z));
			obj.setEntidad((request.getParameter("entidad_ev_"+z)==null)?"":request.getParameter("entidad_ev_"+z));
			obj.setCalle((request.getParameter("calle_ev_"+z)==null)?"":request.getParameter("calle_ev_"+z));
			obj.setPortal((request.getParameter("portal_ev_"+z)==null)?"":request.getParameter("portal_ev_"+z));
			obj.setPiso((request.getParameter("piso_ev_"+z)==null)?"":request.getParameter("piso_ev_"+z));
			obj.setLetra((request.getParameter("letra_ev_"+z)==null)?"":request.getParameter("letra_ev_"+z));
			obj.setCodpro((request.getParameter("codpro_ev_"+z)==null)?"":request.getParameter("codpro_ev_"+z));
			obj.setCodmun((request.getParameter("codmun_ev_"+z)==null)?"":request.getParameter("codmun_ev_"+z));
			obj.setLocali((request.getParameter("locali_ev_"+z)==null)?"":request.getParameter("locali_ev_"+z));
			obj.setCodpst((request.getParameter("codpst_ev_"+z)==null)?"":request.getParameter("codpst_ev_"+z));
			obj.setClavecat((request.getParameter("claveCat_ev_"+z)==null)?"":request.getParameter("claveCat_ev_"+z));
			obj.setFhInscrip((request.getParameter("fhInscrip_ev_"+z)==null)?"":request.getParameter("fhInscrip_ev_"+z));
			
			objListas.getListaEVs().add(obj);
		}
		obj = new P06B61T00Datatype();		
		obj.setExpedi((z+1)+"");
		obj.setCif("");
		obj.setEntidad("");
		obj.setCalle("");
		obj.setPortal("");
		obj.setPiso("");
		obj.setLetra("");
		obj.setCodpro("");
		obj.setCodmun("");
		obj.setLocali("");
		obj.setCodpst("");
		obj.setClavecat("");
		obj.setFhInscrip("");
		objListas.getListaEVs().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de socios y eliminamos el valor seleccionado
	private void eliminarFromListaSocios (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Recorro la lista de socios y elimino aquel cuyo identificador 
		//coincida con idTablaDelete
		for(int i=0;i<objListas.getListaSocios().size();i++){
			P06B22T00Datatype obj = (P06B22T00Datatype)objListas.getListaSocios().get(i);
			if(obj.getIdentificador()!=null && obj.getIdentificador().equals(idTablaDelete)){
				objListas.getListaSocios().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	//Recogemos la lista de socios y eliminamos el valor seleccionado
	private void eliminarFromListaEVs (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Recorro la lista de socios y elimino aquel cuyo identificador 
		//coincida con idTablaDelete
		for(int i=0;i<objListas.getListaEVs().size();i++){
			P06B61T00Datatype obj = (P06B61T00Datatype)objListas.getListaEVs().get(i);
			if(obj.getCif()!=null && obj.getCif().equals(idTablaDelete)){
				objListas.getListaEVs().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	//FIN SOCIOS

	
	//FIN SOCIOS

	
//	SOCIOS INDIRECTOS
//	Recogemos la lista de socios y las actualizamos con los nuevos valores
	private void actualizarListaSociosIndirec (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un socio
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		P06B22T00Datatype obj = null;
		int numSocios = objListas.getListaSociosIndirec().size();
//		objListas.getListaSociosIndirec().clear();
		int z=0;
		for(z=0;z<numSocios;z++){
//			obj = new P06B22T00Datatype();
			obj = (P06B22T00Datatype)objListas.getListaSociosIndirec().get(z);
			obj.setNExpediente(z+"");
			obj.setTipo((request.getParameter("tipo_socioIndirec_"+z)==null)?"":request.getParameter("tipo_socioIndirec_"+z));
			obj.setIdentificador((request.getParameter("identif_socioIndirec_"+z)==null)?"":request.getParameter("identif_socioIndirec_"+z));
			obj.setTipo1((request.getParameter("tipo1_socioIndirec_"+z)==null)?"":request.getParameter("tipo1_socioIndirec_"+z));
			obj.setRazSoc((request.getParameter("razsoc_socioIndirec_"+z)==null)?"":request.getParameter("razsoc_socioIndirec_"+z));
			obj.setNombre((request.getParameter("nombre_socioIndirec_"+z)==null)?"":request.getParameter("nombre_socioIndirec_"+z));
			obj.setApe1((request.getParameter("ape1_socioIndirec_"+z)==null)?"":request.getParameter("ape1_socioIndirec_"+z));
			obj.setApe2((request.getParameter("ape2_socioIndirec_"+z)==null)?"":request.getParameter("ape2_socioIndirec_"+z));
			obj.setDomici((request.getParameter("domici_socioIndirec_"+z)==null)?"":request.getParameter("domici_socioIndirec_"+z));
			obj.setCodmun((request.getParameter("codmun_socioIndirec_"+z)==null)?"":request.getParameter("codmun_socioIndirec_"+z));
			obj.setLocali((request.getParameter("locali_socioIndirec_"+z)==null)?"":request.getParameter("locali_socioIndirec_"+z));
			obj.setCodpro((request.getParameter("codpro_socioIndirec_"+z)==null)?"":request.getParameter("codpro_socioIndirec_"+z));
			obj.setCodpst((request.getParameter("codpst_socioIndirec_"+z)==null)?"":request.getParameter("codpst_socioIndirec_"+z));
			obj.setFecAlta((request.getParameter("fAlta_socioIndirec_"+z)==null)?"":request.getParameter("fAlta_socioIndirec_"+z));
			obj.setFecBaja((request.getParameter("fBaja_socioIndirec_"+z)==null)?"":request.getParameter("fBaja_socioIndirec_"+z));
			obj.setParticipa((request.getParameter("participa_socioIndirec_"+z)==null)?"":request.getParameter("participa_socioIndirec_"+z));
			obj.setIdRep((request.getParameter("idrep_socioIndirec_"+z)==null)?"":request.getParameter("idrep_socioIndirec_"+z));
			obj.setNomRep((request.getParameter("nomrep_socioIndirec_"+z)==null)?"":request.getParameter("nomrep_socioIndirec_"+z));
//			objListas.getListaSociosIndirec().add(obj);	
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de socios y las actualizamos con los nuevos valores
	private void anadirToListaSociosIndirec (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un socio
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B22T00Datatype obj = null;
		int numSocios = objListas.getListaSociosIndirec().size();
		objListas.getListaSociosIndirec().clear();
		int z=0;
		for(z=0;z<numSocios;z++){
			obj = new P06B22T00Datatype();
			
			obj.setNExpediente(z+"");
			obj.setTipo((request.getParameter("tipo_socioIndirec_"+z)==null)?"":request.getParameter("tipo_socioIndirec_"+z));
			obj.setIdentificador((request.getParameter("identif_socioIndirec_"+z)==null)?"":request.getParameter("identif_socioIndirec_"+z));
			obj.setTipo1((request.getParameter("tipo1_socioIndirec_"+z)==null)?"":request.getParameter("tipo1_socioIndirec_"+z));
			obj.setRazSoc((request.getParameter("razsoc_socioIndirec_"+z)==null)?"":request.getParameter("razsoc_socioIndirec_"+z));
			obj.setNombre((request.getParameter("nombre_socioIndirec_"+z)==null)?"":request.getParameter("nombre_socioIndirec_"+z));
			obj.setApe1((request.getParameter("ape1_socioIndirec_"+z)==null)?"":request.getParameter("ape1_socioIndirec_"+z));
			obj.setApe2((request.getParameter("ape2_socioIndirec_"+z)==null)?"":request.getParameter("ape2_socioIndirec_"+z));
			obj.setDomici((request.getParameter("domici_socioIndirec_"+z)==null)?"":request.getParameter("domici_socioIndirec_"+z));
			obj.setCodmun((request.getParameter("codmun_socioIndirec_"+z)==null)?"":request.getParameter("codmun_socioIndirec_"+z));
			obj.setLocali((request.getParameter("locali_socioIndirec_"+z)==null)?"":request.getParameter("locali_socioIndirec_"+z));
			obj.setCodpro((request.getParameter("codpro_socioIndirec_"+z)==null)?"":request.getParameter("codpro_socioIndirec_"+z));
			obj.setCodpst((request.getParameter("codpst_socioIndirec_"+z)==null)?"":request.getParameter("codpst_socioIndirec_"+z));
			obj.setFecAlta((request.getParameter("fAlta_socioIndirec_"+z)==null)?"":request.getParameter("fAlta_socioIndirec_"+z));
			obj.setFecBaja((request.getParameter("fBaja_socioIndirec_"+z)==null)?"":request.getParameter("fBaja_socioIndirec_"+z));
			obj.setParticipa((request.getParameter("participa_socioIndirec_"+z)==null)?"":request.getParameter("participa_socioIndirec_"+z));
			obj.setIdRep((request.getParameter("idrep_socioIndirec_"+z)==null)?"":request.getParameter("idrep_socioIndirec_"+z));
			obj.setNomRep((request.getParameter("nomrep_socioIndirec_"+z)==null)?"":request.getParameter("nomrep_socioIndirec_"+z));
		
			objListas.getListaSociosIndirec().add(obj);	
		}
		obj = new P06B22T00Datatype();		
		obj.setNExpediente((z+1)+"");
		obj.setTipo("");
		obj.setIdentificador("");
		obj.setTipo1("");
		obj.setRazSoc("");
		obj.setNombre("");
		obj.setApe1("");
		obj.setApe2("");
		obj.setDomici("");
		obj.setCodmun("");
		obj.setLocali("");
		obj.setCodpro("");
		obj.setCodpst("");
		obj.setFecAlta("");
		obj.setFecBaja("");
		obj.setParticipa("");
		objListas.getListaSociosIndirec().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de socios y eliminamos el valor seleccionado
	private void eliminarFromListaSociosIndirec (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Recorro la lista de socios y elimino aquel cuyo identificador 
		//coincida con idTablaDelete
		for(int i=0;i<objListas.getListaSociosIndirec().size();i++){
			P06B22T00Datatype obj = (P06B22T00Datatype)objListas.getListaSociosIndirec().get(i);
			if(obj.getIdentificador()!=null && obj.getIdentificador().equals(idTablaDelete)){
				objListas.getListaSociosIndirec().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	//FIN SOCIOS INDIRECTOS
	
	//AUXILIARES EXTERNOS
//	Recogemos la lista de socios y las actualizamos con los nuevos valores
	private void actualizarListaAuxExternos (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un socio
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B22T00Datatype obj = null;
		int numSocios = objListas.getListaAuxExternos().size();
//		objListas.getListaAuxExternos().clear();
		int z=0;
		for(z=0;z<numSocios;z++){
//			obj = new P06B22T00Datatype();
			obj = (P06B22T00Datatype)objListas.getListaAuxExternos().get(z);
			obj.setNExpediente(z+"");
			obj.setTipo((request.getParameter("tipo_auxExterno_"+z)==null)?"":request.getParameter("tipo_auxExterno_"+z));
			obj.setIdentificador((request.getParameter("identif_auxExterno_"+z)==null)?"":request.getParameter("identif_auxExterno_"+z));
			obj.setTipo1((request.getParameter("tipo1_auxExterno_"+z)==null)?"":request.getParameter("tipo1_auxExterno_"+z));
			obj.setRazSoc((request.getParameter("razsoc_auxExterno_"+z)==null)?"":request.getParameter("razsoc_auxExterno_"+z));
			obj.setNombre((request.getParameter("nombre_auxExterno_"+z)==null)?"":request.getParameter("nombre_auxExterno_"+z));
			obj.setApe1((request.getParameter("ape1_auxExterno_"+z)==null)?"":request.getParameter("ape1_auxExterno_"+z));
			obj.setApe2((request.getParameter("ape2_auxExterno_"+z)==null)?"":request.getParameter("ape2_auxExterno_"+z));
			obj.setDomici((request.getParameter("domici_auxExterno_"+z)==null)?"":request.getParameter("domici_auxExterno_"+z));
			obj.setCodmun((request.getParameter("codmun_auxExterno_"+z)==null)?"":request.getParameter("codmun_auxExterno_"+z));
			obj.setLocali((request.getParameter("locali_auxExterno_"+z)==null)?"":request.getParameter("locali_auxExterno_"+z));
			obj.setCodpro((request.getParameter("codpro_auxExterno_"+z)==null)?"":request.getParameter("codpro_auxExterno_"+z));
			obj.setCodpst((request.getParameter("codpst_auxExterno_"+z)==null)?"":request.getParameter("codpst_auxExterno_"+z));
			obj.setFecAlta((request.getParameter("fAlta_auxExterno_"+z)==null)?"":request.getParameter("fAlta_auxExterno_"+z));
			obj.setFecBaja((request.getParameter("fBaja_auxExterno_"+z)==null)?"":request.getParameter("fBaja_auxExterno_"+z));
			obj.setParticipa((request.getParameter("participa_auxExterno_"+z)==null)?"":request.getParameter("participa_auxExterno_"+z));
			obj.setIdRep((request.getParameter("idrep_auxExterno_"+z)==null)?"":request.getParameter("idrep_auxExterno_"+z));
			obj.setNomRep((request.getParameter("nomrep_auxExterno_"+z)==null)?"":request.getParameter("nomrep_auxExterno_"+z));
//			objListas.getListaAuxExternos().add(obj);	
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de socios y las actualizamos con los nuevos valores
	private void anadirToListaAuxExternos (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un socio
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B22T00Datatype obj = null;
		int numSocios = objListas.getListaAuxExternos().size();
		objListas.getListaAuxExternos().clear();
		int z=0;
		for(z=0;z<numSocios;z++){
			obj = new P06B22T00Datatype();
			
			obj.setNExpediente(z+"");
			obj.setTipo((request.getParameter("tipo_auxExterno_"+z)==null)?"":request.getParameter("tipo_auxExterno_"+z));
			obj.setIdentificador((request.getParameter("identif_auxExterno_"+z)==null)?"":request.getParameter("identif_auxExterno_"+z));
			obj.setTipo1((request.getParameter("tipo1_auxExterno_"+z)==null)?"":request.getParameter("tipo1_auxExterno_"+z));
			obj.setRazSoc((request.getParameter("razsoc_auxExterno_"+z)==null)?"":request.getParameter("razsoc_auxExterno_"+z));
			obj.setNombre((request.getParameter("nombre_auxExterno_"+z)==null)?"":request.getParameter("nombre_auxExterno_"+z));
			obj.setApe1((request.getParameter("ape1_auxExterno_"+z)==null)?"":request.getParameter("ape1_auxExterno_"+z));
			obj.setApe2((request.getParameter("ape2_auxExterno_"+z)==null)?"":request.getParameter("ape2_auxExterno_"+z));
			obj.setDomici((request.getParameter("domici_auxExterno_"+z)==null)?"":request.getParameter("domici_auxExterno_"+z));
			obj.setCodmun((request.getParameter("codmun_auxExterno_"+z)==null)?"":request.getParameter("codmun_auxExterno_"+z));
			obj.setLocali((request.getParameter("locali_auxExterno_"+z)==null)?"":request.getParameter("locali_auxExterno_"+z));
			obj.setCodpro((request.getParameter("codpro_auxExterno_"+z)==null)?"":request.getParameter("codpro_auxExterno_"+z));
			obj.setCodpst((request.getParameter("codpst_auxExterno_"+z)==null)?"":request.getParameter("codpst_auxExterno_"+z));
			obj.setFecAlta((request.getParameter("fAlta_auxExterno_"+z)==null)?"":request.getParameter("fAlta_auxExterno_"+z));
			obj.setFecBaja((request.getParameter("fBaja_auxExterno_"+z)==null)?"":request.getParameter("fBaja_auxExterno_"+z));
			obj.setParticipa((request.getParameter("participa_auxExterno_"+z)==null)?"":request.getParameter("participa_auxExterno_"+z));
			obj.setIdRep((request.getParameter("idrep_auxExterno_"+z)==null)?"":request.getParameter("idrep_auxExterno_"+z));
			obj.setNomRep((request.getParameter("nomrep_auxExterno_"+z)==null)?"":request.getParameter("nomrep_auxExterno_"+z));
		
			objListas.getListaAuxExternos().add(obj);	
		}
		obj = new P06B22T00Datatype();		
		obj.setNExpediente((z+1)+"");
		obj.setTipo("");
		obj.setIdentificador("");
		obj.setTipo1("");
		obj.setRazSoc("");
		obj.setNombre("");
		obj.setApe1("");
		obj.setApe2("");
		obj.setDomici("");
		obj.setCodmun("");
		obj.setLocali("");
		obj.setCodpro("");
		obj.setCodpst("");
		obj.setFecAlta("");
		obj.setFecBaja("");
		obj.setParticipa("");
		objListas.getListaAuxExternos().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de socios y eliminamos el valor seleccionado
	private void eliminarFromListaAuxExternos (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Recorro la lista de socios y elimino aquel cuyo identificador 
		//coincida con idTablaDelete
		for(int i=0;i<objListas.getListaAuxExternos().size();i++){
			P06B22T00Datatype obj = (P06B22T00Datatype)objListas.getListaAuxExternos().get(i);
			if(obj.getIdentificador()!=null && obj.getIdentificador().equals(idTablaDelete)){
				objListas.getListaAuxExternos().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	//FIN AUXILIARES EXTERNOS
	

//	ADMINISTRADORES
	//Recogemos la lista de administradores y las actualizamos con los nuevos valores
	private void actualizarListaAdministradores (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un administrador
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		P06B24T00Datatype obj = null;
		int numOrganos = objListas.getListaAdministradores().size();
//		objListas.getListaAdministradores().clear();
		int z=0;
		for(z=0;z<numOrganos;z++){
//			obj = new P06B24T00Datatype();
			obj = (P06B24T00Datatype)objListas.getListaAdministradores().get(z);
			obj.setnExpediente(z+"");
			obj.setIdentificador((request.getParameter("identif_admin_"+z)==null)?"":request.getParameter("identif_admin_"+z));
			obj.setTipo((request.getParameter("tipo_admin_"+z)==null)?"":request.getParameter("tipo_admin_"+z));
			obj.setNombre((request.getParameter("nombre_admin_"+z)==null)?"":request.getParameter("nombre_admin_"+z));
			obj.setApe1((request.getParameter("ape1_admin_"+z)==null)?"":request.getParameter("ape1_admin_"+z));
			obj.setApe2((request.getParameter("ape2_admin_"+z)==null)?"":request.getParameter("ape2_admin_"+z));
			obj.setDomici((request.getParameter("domici_admin_"+z)==null)?"":request.getParameter("domici_admin_"+z));
			obj.setCodmun((request.getParameter("codmun_admin_"+z)==null)?"":request.getParameter("codmun_admin_"+z));
			obj.setLocali((request.getParameter("locali_admin_"+z)==null)?"":request.getParameter("locali_admin_"+z));
			obj.setCodpro((request.getParameter("codpro_admin_"+z)==null)?"":request.getParameter("codpro_admin_"+z));
			obj.setCodpst((request.getParameter("codpst_admin_"+z)==null)?"":request.getParameter("codpst_admin_"+z));
			obj.setPais((request.getParameter("pais_admin_"+z)==null)?"":request.getParameter("pais_admin_"+z));
			obj.setProfesi((request.getParameter("profesi_admin_"+z)==null)?"":request.getParameter("profesi_admin_"+z));
			obj.setCurso((request.getParameter("curso_admin_"+z)==null)?"":request.getParameter("curso_admin_"+z));
			obj.setDenCurso((request.getParameter("denCurso_admin_"+z)==null)?"":request.getParameter("denCurso_admin_"+z));
			obj.setFecSus((request.getParameter("fecSus_admin_"+z)==null)?"":request.getParameter("fecSus_admin_"+z));
			obj.setFecLeSus((request.getParameter("fecLeSus_admin_"+z)==null)?"":request.getParameter("fecLeSus_admin_"+z));
			obj.setFecRev((request.getParameter("fecRev_admin_"+z)==null)?"":request.getParameter("fecRev_admin_"+z));
			obj.setFecInha((request.getParameter("fecInha_admin_"+z)==null)?"":request.getParameter("fecInha_admin_"+z));
			obj.setDurHab((request.getParameter("durHab_admin_"+z)==null)?"":request.getParameter("durHab_admin_"+z));
			obj.setSanciones((request.getParameter("sanciones_admin_"+z)==null)?"":request.getParameter("sanciones_admin_"+z));
			obj.setAcredita((request.getParameter("acredita_admin_"+z)==null)?"":request.getParameter("acredita_admin_"+z));
			obj.setDAcredita((request.getParameter("dAcredita_admin_"+z)==null)?"":request.getParameter("dAcredita_admin_"+z));
			obj.setAcreditaH((request.getParameter("acreditaH_admin_"+z)==null)?"":request.getParameter("acreditaH_admin_"+z));
			obj.setDAcreditaH((request.getParameter("dAcreditaH_admin_"+z)==null)?"":request.getParameter("dAcreditaH_admin_"+z));
			obj.setVinculaciones((request.getParameter("vinculaciones_admin_"+z)==null)?"":request.getParameter("vinculaciones_admin_"+z));
			obj.setEnAseAutori((request.getParameter("enAseAutori_admin_"+z)==null)?"":request.getParameter("enAseAutori_admin_"+z));
			obj.setIdCargo((request.getParameter("idCargo_admin_"+z)==null)?"":request.getParameter("idCargo_admin_"+z));
			obj.setFechNom((request.getParameter("fechNom_admin_"+z)==null)?"":request.getParameter("fechNom_admin_"+z));
			obj.setFecCese((request.getParameter("fecCese_admin_"+z)==null)?"":request.getParameter("fecCese_admin_"+z));
			if (request.getParameter("operacion_admin_"+z)!=null){
				obj.setOperacion(Integer.parseInt(request.getParameter("operacion_admin_"+z)));				
			}
			if (request.getParameter("aprobado_admin_"+z)!=null){
				obj.setAprobado(Integer.parseInt(request.getParameter("aprobado_admin_"+z)));				
			}
			//Aprobamos todo
			obj.setAprobado(1);				

//			objListas.getListaAdministradores().add(obj);	
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de rganos y las actualizamos con los nuevos valores
	private void anadirToListaAdministradores (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un rgano
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B24T00Datatype obj = null;
		int numOrganos = objListas.getListaAdministradores().size();
		objListas.getListaAdministradores().clear();
		int z=0;
		for(z=0;z<numOrganos;z++){
			obj = new P06B24T00Datatype();
			
			obj.setnExpediente(z+"");
			obj.setIdentificador((request.getParameter("identif_admin_"+z)==null)?"":request.getParameter("identif_admin_"+z));
			obj.setTipo((request.getParameter("tipo_admin_"+z)==null)?"":request.getParameter("tipo_admin_"+z));
			obj.setNombre((request.getParameter("nombre_admin_"+z)==null)?"":request.getParameter("nombre_admin_"+z));
			obj.setApe1((request.getParameter("ape1_admin_"+z)==null)?"":request.getParameter("ape1_admin_"+z));
			obj.setApe2((request.getParameter("ape2_admin_"+z)==null)?"":request.getParameter("ape2_admin_"+z));
			obj.setDomici((request.getParameter("domici_admin_"+z)==null)?"":request.getParameter("domici_admin_"+z));
			obj.setCodmun((request.getParameter("codmun_admin_"+z)==null)?"":request.getParameter("codmun_admin_"+z));
			obj.setLocali((request.getParameter("locali_admin_"+z)==null)?"":request.getParameter("locali_admin_"+z));
			obj.setCodpro((request.getParameter("codpro_admin_"+z)==null)?"":request.getParameter("codpro_admin_"+z));
			obj.setCodpst((request.getParameter("codpst_admin_"+z)==null)?"":request.getParameter("codpst_admin_"+z));
			obj.setPais((request.getParameter("pais_admin_"+z)==null)?"":request.getParameter("pais_admin_"+z));
			obj.setProfesi((request.getParameter("profesi_admin_"+z)==null)?"":request.getParameter("profesi_admin_"+z));
			obj.setCurso((request.getParameter("curso_admin_"+z)==null)?"":request.getParameter("curso_admin_"+z));
			obj.setDenCurso((request.getParameter("denCurso_admin_"+z)==null)?"":request.getParameter("denCurso_admin_"+z));
			obj.setFecSus((request.getParameter("fecSus_admin_"+z)==null)?"":request.getParameter("fecSus_admin_"+z));
			obj.setFecLeSus((request.getParameter("fecLeSus_admin_"+z)==null)?"":request.getParameter("fecLeSus_admin_"+z));
			obj.setFecRev((request.getParameter("fecRev_admin_"+z)==null)?"":request.getParameter("fecRev_admin_"+z));
			obj.setFecInha((request.getParameter("fecInha_admin_"+z)==null)?"":request.getParameter("fecInha_admin_"+z));
			obj.setDurHab((request.getParameter("durHab_admin_"+z)==null)?"":request.getParameter("durHab_admin_"+z));
			obj.setSanciones((request.getParameter("sanciones_admin_"+z)==null)?"":request.getParameter("sanciones_admin_"+z));
			obj.setAcredita((request.getParameter("acredita_admin_"+z)==null)?"":request.getParameter("acredita_admin_"+z));
			obj.setDAcredita((request.getParameter("dAcredita_admin_"+z)==null)?"":request.getParameter("dAcredita_admin_"+z));
			obj.setAcreditaH((request.getParameter("acreditaH_admin_"+z)==null)?"":request.getParameter("acreditaH_admin_"+z));
			obj.setDAcreditaH((request.getParameter("dAcreditaH_admin_"+z)==null)?"":request.getParameter("dAcreditaH_admin_"+z));
			obj.setVinculaciones((request.getParameter("vinculaciones_admin_"+z)==null)?"":request.getParameter("vinculaciones_admin_"+z));
			obj.setEnAseAutori((request.getParameter("enAseAutori_admin_"+z)==null)?"":request.getParameter("enAseAutori_admin_"+z));
			obj.setIdCargo((request.getParameter("idCargo_admin_"+z)==null)?"":request.getParameter("idCargo_admin_"+z));
			obj.setFechNom((request.getParameter("fechNom_admin_"+z)==null)?"":request.getParameter("fechNom_admin_"+z));
			obj.setFecCese((request.getParameter("fecCese_admin_"+z)==null)?"":request.getParameter("fecCese_admin_"+z));
						
			objListas.getListaAdministradores().add(obj);	
		}
		obj = new P06B24T00Datatype();
		
		obj.setnExpediente((z+1)+"");
		obj.setIdentificador("");
		obj.setTipo("");
		obj.setNombre("");
		obj.setApe1("");
		obj.setApe2("");
		obj.setDomici("");
		obj.setCodmun("");
		obj.setLocali("");
		obj.setCodpro("");
		obj.setCodpst("");
		obj.setPais("");
		obj.setProfesi("");
		obj.setCurso("");
		obj.setDenCurso("");
		obj.setFecSus("");
		obj.setFecLeSus("");
		obj.setFecRev("");
		obj.setFecInha("");
		obj.setDurHab("");
		obj.setSanciones("");
		obj.setAcredita("");
		obj.setDAcredita("");
		obj.setAcreditaH("");
		obj.setDAcreditaH("");
		obj.setVinculaciones("");
		obj.setEnAseAutori("");
		obj.setIdCargo("");
		obj.setFechNom("");
		obj.setFecCese("");
		
		objListas.getListaAdministradores().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de rganos y eliminamos el valor seleccionado
	private void eliminarFromListaAdministradores (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		String idCargoDelete = (request.getParameter("idCargoDelete")==null)?"":request.getParameter("idCargoDelete");
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Recorro la lista de rganos y elimino aquel cuyo identificador 
		//coincida con idTablaDelete
		for(int i=0;i<objListas.getListaAdministradores().size();i++){
			P06B24T00Datatype obj = (P06B24T00Datatype)objListas.getListaAdministradores().get(i);
			if(obj.getIdentificador()!=null && obj.getIdentificador().equals(idTablaDelete) && idCargoDelete.equals(obj.getIdCargo())){
				objListas.getListaAdministradores().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}	
	//FIN ADMINISTRADORES
	
	
	//ORGANOS DIRECCION
	//Recogemos la lista de rganos y las actualizamos con los nuevos valores
	private void actualizarListaOrganos (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un rgano
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		P06B24T00Datatype obj = null;
		int numOrganos = objListas.getListaOrganos().size();
//		objListas.getListaOrganos().clear();
		int z=0;
		for(z=0;z<numOrganos;z++){
//			obj = new P06B24T00Datatype();
			obj = (P06B24T00Datatype)objListas.getListaOrganos().get(z);
			obj.setnExpediente(z+"");
			obj.setIdentificador((request.getParameter("identif_organo_"+z)==null)?"":request.getParameter("identif_organo_"+z));
			obj.setTipo((request.getParameter("tipo_organo_"+z)==null)?"":request.getParameter("tipo_organo_"+z));
			obj.setNombre((request.getParameter("nombre_organo_"+z)==null)?"":request.getParameter("nombre_organo_"+z));
			obj.setApe1((request.getParameter("ape1_organo_"+z)==null)?"":request.getParameter("ape1_organo_"+z));
			obj.setApe2((request.getParameter("ape2_organo_"+z)==null)?"":request.getParameter("ape2_organo_"+z));
			obj.setDomici((request.getParameter("domici_organo_"+z)==null)?"":request.getParameter("domici_organo_"+z));
			obj.setCodmun((request.getParameter("codmun_organo_"+z)==null)?"":request.getParameter("codmun_organo_"+z));
			obj.setLocali((request.getParameter("locali_organo_"+z)==null)?"":request.getParameter("locali_organo_"+z));
			obj.setCodpro((request.getParameter("codpro_organo_"+z)==null)?"":request.getParameter("codpro_organo_"+z));
			obj.setCodpst((request.getParameter("codpst_organo_"+z)==null)?"":request.getParameter("codpst_organo_"+z));
			obj.setPais((request.getParameter("pais_organo_"+z)==null)?"":request.getParameter("pais_organo_"+z));
			obj.setProfesi((request.getParameter("profesi_organo_"+z)==null)?"":request.getParameter("profesi_organo_"+z));
			obj.setCurso((request.getParameter("curso_organo_"+z)==null)?"":request.getParameter("curso_organo_"+z));
			obj.setDenCurso((request.getParameter("denCurso_organo_"+z)==null)?"":request.getParameter("denCurso_organo_"+z));
			obj.setFecSus((request.getParameter("fecSus_organo_"+z)==null)?"":request.getParameter("fecSus_organo_"+z));
			obj.setFecLeSus((request.getParameter("fecLeSus_organo_"+z)==null)?"":request.getParameter("fecLeSus_organo_"+z));
			obj.setFecRev((request.getParameter("fecRev_organo_"+z)==null)?"":request.getParameter("fecRev_organo_"+z));
			obj.setFecInha((request.getParameter("fecInha_organo_"+z)==null)?"":request.getParameter("fecInha_organo_"+z));
			obj.setDurHab((request.getParameter("durHab_organo_"+z)==null)?"":request.getParameter("durHab_organo_"+z));
			obj.setSanciones((request.getParameter("sanciones_organo_"+z)==null)?"":request.getParameter("sanciones_organo_"+z));
			obj.setAcredita((request.getParameter("acredita_organo_"+z)==null)?"":request.getParameter("acredita_organo_"+z));
			obj.setDAcredita((request.getParameter("dAcredita_organo_"+z)==null)?"":request.getParameter("dAcredita_organo_"+z));
			obj.setAcreditaH((request.getParameter("acreditaH_organo_"+z)==null)?"":request.getParameter("acreditaH_organo_"+z));
			obj.setDAcreditaH((request.getParameter("dAcreditaH_organo_"+z)==null)?"":request.getParameter("dAcreditaH_organo_"+z));
			obj.setVinculaciones((request.getParameter("vinculaciones_organo_"+z)==null)?"":request.getParameter("vinculaciones_organo_"+z));
			obj.setEnAseAutori((request.getParameter("enAseAutori_organo_"+z)==null)?"":request.getParameter("enAseAutori_organo_"+z));
			obj.setIdCargo((request.getParameter("idCargo_organo_"+z)==null)?"":request.getParameter("idCargo_organo_"+z));
			obj.setFechNom((request.getParameter("fechNom_organo_"+z)==null)?"":request.getParameter("fechNom_organo_"+z));
			obj.setFecCese((request.getParameter("fecCese_organo_"+z)==null)?"":request.getParameter("fecCese_organo_"+z));
			if (request.getParameter("operacion_organo_"+z)!=null){
				obj.setOperacion(Integer.parseInt(request.getParameter("operacion_organo_"+z)));				
			}
			if (request.getParameter("aprobado_organo_"+z)!=null){
				obj.setAprobado(Integer.parseInt(request.getParameter("aprobado_organo_"+z)));				
			}
			//Aprobamos todo
			obj.setAprobado(1);				

//			objListas.getListaOrganos().add(obj);
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de rganos y las actualizamos con los nuevos valores
	private void anadirToListaOrganos (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un rgano
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B24T00Datatype obj = null;
		int numOrganos = objListas.getListaOrganos().size();
		objListas.getListaOrganos().clear();
		int z=0;
		for(z=0;z<numOrganos;z++){
			obj = new P06B24T00Datatype();
			
			obj.setnExpediente(z+"");
			obj.setIdentificador((request.getParameter("identif_organo_"+z)==null)?"":request.getParameter("identif_organo_"+z));
			obj.setTipo((request.getParameter("tipo_organo_"+z)==null)?"":request.getParameter("tipo_organo_"+z));
			obj.setNombre((request.getParameter("nombre_organo_"+z)==null)?"":request.getParameter("nombre_organo_"+z));
			obj.setApe1((request.getParameter("ape1_organo_"+z)==null)?"":request.getParameter("ape1_organo_"+z));
			obj.setApe2((request.getParameter("ape2_organo_"+z)==null)?"":request.getParameter("ape2_organo_"+z));
			obj.setDomici((request.getParameter("domici_organo_"+z)==null)?"":request.getParameter("domici_organo_"+z));
			obj.setCodmun((request.getParameter("codmun_organo_"+z)==null)?"":request.getParameter("codmun_organo_"+z));
			obj.setLocali((request.getParameter("locali_organo_"+z)==null)?"":request.getParameter("locali_organo_"+z));
			obj.setCodpro((request.getParameter("codpro_organo_"+z)==null)?"":request.getParameter("codpro_organo_"+z));
			obj.setCodpst((request.getParameter("codpst_organo_"+z)==null)?"":request.getParameter("codpst_organo_"+z));
			obj.setPais((request.getParameter("pais_organo_"+z)==null)?"":request.getParameter("pais_organo_"+z));
			obj.setProfesi((request.getParameter("profesi_organo_"+z)==null)?"":request.getParameter("profesi_organo_"+z));
			obj.setCurso((request.getParameter("curso_organo_"+z)==null)?"":request.getParameter("curso_organo_"+z));
			obj.setDenCurso((request.getParameter("denCurso_organo_"+z)==null)?"":request.getParameter("denCurso_organo_"+z));
			obj.setFecSus((request.getParameter("fecSus_organo_"+z)==null)?"":request.getParameter("fecSus_organo_"+z));
			obj.setFecLeSus((request.getParameter("fecLeSus_organo_"+z)==null)?"":request.getParameter("fecLeSus_organo_"+z));
			obj.setFecRev((request.getParameter("fecRev_organo_"+z)==null)?"":request.getParameter("fecRev_organo_"+z));
			obj.setFecInha((request.getParameter("fecInha_organo_"+z)==null)?"":request.getParameter("fecInha_organo_"+z));
			obj.setDurHab((request.getParameter("durHab_organo_"+z)==null)?"":request.getParameter("durHab_organo_"+z));
			obj.setSanciones((request.getParameter("sanciones_organo_"+z)==null)?"":request.getParameter("sanciones_organo_"+z));
			obj.setAcredita((request.getParameter("acredita_organo_"+z)==null)?"":request.getParameter("acredita_organo_"+z));
			obj.setDAcredita((request.getParameter("dAcredita_organo_"+z)==null)?"":request.getParameter("dAcredita_organo_"+z));
			obj.setAcreditaH((request.getParameter("acreditaH_organo_"+z)==null)?"":request.getParameter("acreditaH_organo_"+z));
			obj.setDAcreditaH((request.getParameter("dAcreditaH_organo_"+z)==null)?"":request.getParameter("dAcreditaH_organo_"+z));
			obj.setVinculaciones((request.getParameter("vinculaciones_organo_"+z)==null)?"":request.getParameter("vinculaciones_organo_"+z));
			obj.setEnAseAutori((request.getParameter("enAseAutori_organo_"+z)==null)?"":request.getParameter("enAseAutori_organo_"+z));
			obj.setIdCargo((request.getParameter("idCargo_organo_"+z)==null)?"":request.getParameter("idCargo_organo_"+z));
			obj.setFechNom((request.getParameter("fechNom_organo_"+z)==null)?"":request.getParameter("fechNom_organo_"+z));
			obj.setFecCese((request.getParameter("fecCese_organo_"+z)==null)?"":request.getParameter("fecCese_organo_"+z));
						
			objListas.getListaOrganos().add(obj);			
		}
		obj = new P06B24T00Datatype();
		
		obj.setnExpediente((z+1)+"");
		obj.setIdentificador("");
		obj.setTipo("");
		obj.setNombre("");
		obj.setApe1("");
		obj.setApe2("");
		obj.setDomici("");
		obj.setCodmun("");
		obj.setLocali("");
		obj.setCodpro("");
		obj.setCodpst("");
		obj.setPais("");
		obj.setProfesi("");
		obj.setCurso("");
		obj.setDenCurso("");
		obj.setFecSus("");
		obj.setFecLeSus("");
		obj.setFecRev("");
		obj.setFecInha("");
		obj.setDurHab("");
		obj.setSanciones("");
		obj.setAcredita("");
		obj.setDAcredita("");
		obj.setAcreditaH("");
		obj.setDAcreditaH("");
		obj.setVinculaciones("");
		obj.setEnAseAutori("");
		obj.setIdCargo("");
		obj.setFechNom("");
		obj.setFecCese("");
		
		objListas.getListaOrganos().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de rganos y eliminamos el valor seleccionado
	private void eliminarFromListaOrganos (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		String idCargoDelete = (request.getParameter("idCargoDelete")==null)?"":request.getParameter("idCargoDelete");
		
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Recorro la lista de rganos y elimino aquel cuyo identificador 
		//coincida con idTablaDelete
		for(int i=0;i<objListas.getListaOrganos().size();i++){
			P06B24T00Datatype obj = (P06B24T00Datatype)objListas.getListaOrganos().get(i);
			if(obj.getIdentificador()!=null && obj.getIdentificador().equals(idTablaDelete) && idCargoDelete.equals(obj.getIdCargo())){
				objListas.getListaOrganos().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	//FIN ORGANOS DIRECCION
	
	
//	DIRECCION TECNICA
	//Recogemos la lista de rganos y las actualizamos con los nuevos valores
	private void actualizarListaDirecTec (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir direccion tecnica
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		P06B24T00Datatype obj = null;
		int numOrganos = objListas.getListaDirecTec().size();
//		objListas.getListaDirecTec().clear();
		int z=0;
		for(z=0;z<numOrganos;z++){
//			obj = new P06B24T00Datatype();
			obj = (P06B24T00Datatype)objListas.getListaDirecTec().get(z);
			obj.setnExpediente(z+"");
			obj.setIdentificador((request.getParameter("identif_direcTec_"+z)==null)?"":request.getParameter("identif_direcTec_"+z));
			obj.setTipo((request.getParameter("tipo_direcTec_"+z)==null)?"":request.getParameter("tipo_direcTec_"+z));
			obj.setNombre((request.getParameter("nombre_direcTec_"+z)==null)?"":request.getParameter("nombre_direcTec_"+z));
			obj.setApe1((request.getParameter("ape1_direcTec_"+z)==null)?"":request.getParameter("ape1_direcTec_"+z));
			obj.setApe2((request.getParameter("ape2_direcTec_"+z)==null)?"":request.getParameter("ape2_direcTec_"+z));
			obj.setDomici((request.getParameter("domici_direcTec_"+z)==null)?"":request.getParameter("domici_direcTec_"+z));
			obj.setCodmun((request.getParameter("codmun_direcTec_"+z)==null)?"":request.getParameter("codmun_direcTec_"+z));
			obj.setLocali((request.getParameter("locali_direcTec_"+z)==null)?"":request.getParameter("locali_direcTec_"+z));
			obj.setCodpro((request.getParameter("codpro_direcTec_"+z)==null)?"":request.getParameter("codpro_direcTec_"+z));
			obj.setCodpst((request.getParameter("codpst_direcTec_"+z)==null)?"":request.getParameter("codpst_direcTec_"+z));
			obj.setPais((request.getParameter("pais_direcTec_"+z)==null)?"":request.getParameter("pais_direcTec_"+z));
			obj.setProfesi((request.getParameter("profesi_direcTec_"+z)==null)?"":request.getParameter("profesi_direcTec_"+z));
			obj.setCurso((request.getParameter("curso_direcTec_"+z)==null)?"":request.getParameter("curso_direcTec_"+z));
			obj.setDenCurso((request.getParameter("denCurso_direcTec_"+z)==null)?"":request.getParameter("denCurso_direcTec_"+z));
			obj.setFecSus((request.getParameter("fecSus_direcTec_"+z)==null)?"":request.getParameter("fecSus_direcTec_"+z));
			obj.setFecLeSus((request.getParameter("fecLeSus_direcTec_"+z)==null)?"":request.getParameter("fecLeSus_direcTec_"+z));
			obj.setFecRev((request.getParameter("fecRev_direcTec_"+z)==null)?"":request.getParameter("fecRev_direcTec_"+z));
			obj.setFecInha((request.getParameter("fecInha_direcTec_"+z)==null)?"":request.getParameter("fecInha_direcTec_"+z));
			obj.setDurHab((request.getParameter("durHab_direcTec_"+z)==null)?"":request.getParameter("durHab_direcTec_"+z));
			obj.setSanciones((request.getParameter("sanciones_direcTec_"+z)==null)?"":request.getParameter("sanciones_direcTec_"+z));
			obj.setAcredita((request.getParameter("acredita_direcTec_"+z)==null)?"":request.getParameter("acredita_direcTec_"+z));
			obj.setDAcredita((request.getParameter("dAcredita_direcTec_"+z)==null)?"":request.getParameter("dAcredita_direcTec_"+z));
			obj.setAcreditaH((request.getParameter("acreditaH_direcTec_"+z)==null)?"":request.getParameter("acreditaH_direcTec_"+z));
			obj.setDAcreditaH((request.getParameter("dAcreditaH_direcTec_"+z)==null)?"":request.getParameter("dAcreditaH_direcTec_"+z));
			obj.setVinculaciones((request.getParameter("vinculaciones_direcTec_"+z)==null)?"":request.getParameter("vinculaciones_direcTec_"+z));
			obj.setEnAseAutori((request.getParameter("enAseAutori_direcTec_"+z)==null)?"":request.getParameter("enAseAutori_direcTec_"+z));
			obj.setIdCargo((request.getParameter("idCargo_direcTec_"+z)==null)?"":request.getParameter("idCargo_direcTec_"+z));
			obj.setFechNom((request.getParameter("fechNom_direcTec_"+z)==null)?"":request.getParameter("fechNom_direcTec_"+z));
			obj.setFecCese((request.getParameter("fecCese_direcTec_"+z)==null)?"":request.getParameter("fecCese_direcTec_"+z));
			if (request.getParameter("operacion_direcTec_"+z)!=null){
				obj.setOperacion(Integer.parseInt(request.getParameter("operacion_direcTec_"+z)));				
			}
			if (request.getParameter("aprobado_direcTec_"+z)!=null){
				obj.setAprobado(Integer.parseInt(request.getParameter("aprobado_direcTec_"+z)));				
			}
			//Aprobamos todo
			obj.setAprobado(1);				

//			objListas.getListaDirecTec().add(obj);	
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de rganos y las actualizamos con los nuevos valores
	private void anadirToListaDirecTec (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un direccion tecnica
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B24T00Datatype obj = null;
		int numOrganos = objListas.getListaDirecTec().size();
		objListas.getListaDirecTec().clear();
		int z=0;
		for(z=0;z<numOrganos;z++){
			obj = new P06B24T00Datatype();
			
			obj.setnExpediente(z+"");
			obj.setIdentificador((request.getParameter("identif_direcTec_"+z)==null)?"":request.getParameter("identif_direcTec_"+z));
			obj.setTipo((request.getParameter("tipo_direcTec_"+z)==null)?"":request.getParameter("tipo_direcTec_"+z));
			obj.setNombre((request.getParameter("nombre_direcTec_"+z)==null)?"":request.getParameter("nombre_direcTec_"+z));
			obj.setApe1((request.getParameter("ape1_direcTec_"+z)==null)?"":request.getParameter("ape1_direcTec_"+z));
			obj.setApe2((request.getParameter("ape2_direcTec_"+z)==null)?"":request.getParameter("ape2_direcTec_"+z));
			obj.setDomici((request.getParameter("domici_direcTec_"+z)==null)?"":request.getParameter("domici_direcTec_"+z));
			obj.setCodmun((request.getParameter("codmun_direcTec_"+z)==null)?"":request.getParameter("codmun_direcTec_"+z));
			obj.setLocali((request.getParameter("locali_direcTec_"+z)==null)?"":request.getParameter("locali_direcTec_"+z));
			obj.setCodpro((request.getParameter("codpro_direcTec_"+z)==null)?"":request.getParameter("codpro_direcTec_"+z));
			obj.setCodpst((request.getParameter("codpst_direcTec_"+z)==null)?"":request.getParameter("codpst_direcTec_"+z));
			obj.setPais((request.getParameter("pais_direcTec_"+z)==null)?"":request.getParameter("pais_direcTec_"+z));
			obj.setProfesi((request.getParameter("profesi_direcTec_"+z)==null)?"":request.getParameter("profesi_direcTec_"+z));
			obj.setCurso((request.getParameter("curso_direcTec_"+z)==null)?"":request.getParameter("curso_direcTec_"+z));
			obj.setDenCurso((request.getParameter("denCurso_direcTec_"+z)==null)?"":request.getParameter("denCurso_direcTec_"+z));
			obj.setFecSus((request.getParameter("fecSus_direcTec_"+z)==null)?"":request.getParameter("fecSus_direcTec_"+z));
			obj.setFecLeSus((request.getParameter("fecLeSus_direcTec_"+z)==null)?"":request.getParameter("fecLeSus_direcTec_"+z));
			obj.setFecRev((request.getParameter("fecRev_direcTec_"+z)==null)?"":request.getParameter("fecRev_direcTec_"+z));
			obj.setFecInha((request.getParameter("fecInha_direcTec_"+z)==null)?"":request.getParameter("fecInha_direcTec_"+z));
			obj.setDurHab((request.getParameter("durHab_direcTec_"+z)==null)?"":request.getParameter("durHab_direcTec_"+z));
			obj.setSanciones((request.getParameter("sanciones_direcTec_"+z)==null)?"":request.getParameter("sanciones_direcTec_"+z));
			obj.setAcredita((request.getParameter("acredita_direcTec_"+z)==null)?"":request.getParameter("acredita_direcTec_"+z));
			obj.setDAcredita((request.getParameter("dAcredita_direcTec_"+z)==null)?"":request.getParameter("dAcredita_direcTec_"+z));
			obj.setAcreditaH((request.getParameter("acreditaH_direcTec_"+z)==null)?"":request.getParameter("acreditaH_direcTec_"+z));
			obj.setDAcreditaH((request.getParameter("dAcreditaH_direcTec_"+z)==null)?"":request.getParameter("dAcreditaH_direcTec_"+z));
			obj.setVinculaciones((request.getParameter("vinculaciones_direcTec_"+z)==null)?"":request.getParameter("vinculaciones_direcTec_"+z));
			obj.setEnAseAutori((request.getParameter("enAseAutori_direcTec_"+z)==null)?"":request.getParameter("enAseAutori_direcTec_"+z));
			obj.setIdCargo((request.getParameter("idCargo_direcTec_"+z)==null)?"":request.getParameter("idCargo_direcTec_"+z));
			obj.setFechNom((request.getParameter("fechNom_direcTec_"+z)==null)?"":request.getParameter("fechNom_direcTec_"+z));
			obj.setFecCese((request.getParameter("fecCese_direcTec_"+z)==null)?"":request.getParameter("fecCese_direcTec_"+z));
						
			objListas.getListaDirecTec().add(obj);	
		}
		obj = new P06B24T00Datatype();
		
		obj.setnExpediente((z+1)+"");
		obj.setIdentificador("");
		obj.setTipo("");
		obj.setNombre("");
		obj.setApe1("");
		obj.setApe2("");
		obj.setDomici("");
		obj.setCodmun("");
		obj.setLocali("");
		obj.setCodpro("");
		obj.setCodpst("");
		obj.setPais("");
		obj.setProfesi("");
		obj.setCurso("");
		obj.setDenCurso("");
		obj.setFecSus("");
		obj.setFecLeSus("");
		obj.setFecRev("");
		obj.setFecInha("");
		obj.setDurHab("");
		obj.setSanciones("");
		obj.setAcredita("");
		obj.setDAcredita("");
		obj.setAcreditaH("");
		obj.setDAcreditaH("");
		obj.setVinculaciones("");
		obj.setEnAseAutori("");
		obj.setIdCargo("");
		obj.setFechNom("");
		obj.setFecCese("");
		
		objListas.getListaDirecTec().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de rganos y eliminamos el valor seleccionado
	private void eliminarFromListaDirecTec (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		String idCargoDelete = (request.getParameter("idCargoDelete")==null)?"":request.getParameter("idCargoDelete");
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Recorro la lista de rganos y elimino aquel cuyo identificador 
		//coincida con idTablaDelete
		for(int i=0;i<objListas.getListaDirecTec().size();i++){
			P06B24T00Datatype obj = (P06B24T00Datatype)objListas.getListaDirecTec().get(i);
			if(obj.getIdentificador()!=null && obj.getIdentificador().equals(idTablaDelete) && idCargoDelete.equals(obj.getIdCargo())){
				objListas.getListaDirecTec().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	//FIN DIRECCION TECNICA

	
//	OTROS DIRECCION
	//Recogemos la lista de rganos y las actualizamos con los nuevos valores
	private void actualizarListaOtrosDirec (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un rgano
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		P06B24T00Datatype obj = null;
		int numOrganos = objListas.getListaOtrosDirec().size();
//		objListas.getListaOtrosDirec().clear();
		int z=0;
		for(z=0;z<numOrganos;z++){
//			obj = new P06B24T00Datatype();
			obj = (P06B24T00Datatype)objListas.getListaOtrosDirec().get(z);
			obj.setnExpediente(z+"");
			obj.setIdentificador((request.getParameter("identif_otrosDirec_"+z)==null)?"":request.getParameter("identif_otrosDirec_"+z));
			obj.setTipo((request.getParameter("tipo_otrosDirec_"+z)==null)?"":request.getParameter("tipo_otrosDirec_"+z));
			obj.setNombre((request.getParameter("nombre_otrosDirec_"+z)==null)?"":request.getParameter("nombre_otrosDirec_"+z));
			obj.setApe1((request.getParameter("ape1_otrosDirec_"+z)==null)?"":request.getParameter("ape1_otrosDirec_"+z));
			obj.setApe2((request.getParameter("ape2_otrosDirec_"+z)==null)?"":request.getParameter("ape2_otrosDirec_"+z));
			obj.setDomici((request.getParameter("domici_otrosDirec_"+z)==null)?"":request.getParameter("domici_otrosDirec_"+z));
			obj.setCodmun((request.getParameter("codmun_otrosDirec_"+z)==null)?"":request.getParameter("codmun_otrosDirec_"+z));
			obj.setLocali((request.getParameter("locali_otrosDirec_"+z)==null)?"":request.getParameter("locali_otrosDirec_"+z));
			obj.setCodpro((request.getParameter("codpro_otrosDirec_"+z)==null)?"":request.getParameter("codpro_otrosDirec_"+z));
			obj.setCodpst((request.getParameter("codpst_otrosDirec_"+z)==null)?"":request.getParameter("codpst_otrosDirec_"+z));
			obj.setPais((request.getParameter("pais_otrosDirec_"+z)==null)?"":request.getParameter("pais_otrosDirec_"+z));
			obj.setProfesi((request.getParameter("profesi_otrosDirec_"+z)==null)?"":request.getParameter("profesi_otrosDirec_"+z));
			obj.setCurso((request.getParameter("curso_otrosDirec_"+z)==null)?"":request.getParameter("curso_otrosDirec_"+z));
			obj.setDenCurso((request.getParameter("denCurso_otrosDirec_"+z)==null)?"":request.getParameter("denCurso_otrosDirec_"+z));
			obj.setFecSus((request.getParameter("fecSus_otrosDirec_"+z)==null)?"":request.getParameter("fecSus_otrosDirec_"+z));
			obj.setFecLeSus((request.getParameter("fecLeSus_otrosDirec_"+z)==null)?"":request.getParameter("fecLeSus_otrosDirec_"+z));
			obj.setFecRev((request.getParameter("fecRev_otrosDirec_"+z)==null)?"":request.getParameter("fecRev_otrosDirec_"+z));
			obj.setFecInha((request.getParameter("fecInha_otrosDirec_"+z)==null)?"":request.getParameter("fecInha_otrosDirec_"+z));
			obj.setDurHab((request.getParameter("durHab_otrosDirec_"+z)==null)?"":request.getParameter("durHab_otrosDirec_"+z));
			obj.setSanciones((request.getParameter("sanciones_otrosDirec_"+z)==null)?"":request.getParameter("sanciones_otrosDirec_"+z));
			obj.setAcredita((request.getParameter("acredita_otrosDirec_"+z)==null)?"":request.getParameter("acredita_otrosDirec_"+z));
			obj.setDAcredita((request.getParameter("dAcredita_otrosDirec_"+z)==null)?"":request.getParameter("dAcredita_otrosDirec_"+z));
			obj.setAcreditaH((request.getParameter("acreditaH_otrosDirec_"+z)==null)?"":request.getParameter("acreditaH_otrosDirec_"+z));
			obj.setDAcreditaH((request.getParameter("dAcreditaH_otrosDirec_"+z)==null)?"":request.getParameter("dAcreditaH_otrosDirec_"+z));
			obj.setVinculaciones((request.getParameter("vinculaciones_otrosDirec_"+z)==null)?"":request.getParameter("vinculaciones_otrosDirec_"+z));
			obj.setEnAseAutori((request.getParameter("enAseAutori_otrosDirec_"+z)==null)?"":request.getParameter("enAseAutori_otrosDirec_"+z));
			obj.setIdCargo((request.getParameter("idCargo_otrosDirec_"+z)==null)?"":request.getParameter("idCargo_otrosDirec_"+z));
			obj.setFechNom((request.getParameter("fechNom_otrosDirec_"+z)==null)?"":request.getParameter("fechNom_otrosDirec_"+z));
			obj.setFecCese((request.getParameter("fecCese_otrosDirec_"+z)==null)?"":request.getParameter("fecCese_otrosDirec_"+z));
			if (request.getParameter("operacion_otrosDirec_"+z)!=null){
				obj.setOperacion(Integer.parseInt(request.getParameter("operacion_otrosDirec_"+z)));				
			}
			if (request.getParameter("aprobado_otrosDirec_"+z)!=null){
				obj.setAprobado(Integer.parseInt(request.getParameter("aprobado_otrosDirec_"+z)));				
			}
			//Aprobamos todo
			obj.setAprobado(1);				

//			objListas.getListaOtrosDirec().add(obj);	
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de rganos y las actualizamos con los nuevos valores
	private void anadirToListaOtrosDirec (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un rgano
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B24T00Datatype obj = null;
		int numOrganos = objListas.getListaOtrosDirec().size();
		objListas.getListaOtrosDirec().clear();
		int z=0;
		for(z=0;z<numOrganos;z++){
			obj = new P06B24T00Datatype();
			
			obj.setnExpediente(z+"");
			obj.setIdentificador((request.getParameter("identif_otrosDirec_"+z)==null)?"":request.getParameter("identif_otrosDirec_"+z));
			obj.setTipo((request.getParameter("tipo_otrosDirec_"+z)==null)?"":request.getParameter("tipo_otrosDirec_"+z));
			obj.setNombre((request.getParameter("nombre_otrosDirec_"+z)==null)?"":request.getParameter("nombre_otrosDirec_"+z));
			obj.setApe1((request.getParameter("ape1_otrosDirec_"+z)==null)?"":request.getParameter("ape1_otrosDirec_"+z));
			obj.setApe2((request.getParameter("ape2_otrosDirec_"+z)==null)?"":request.getParameter("ape2_otrosDirec_"+z));
			obj.setDomici((request.getParameter("domici_otrosDirec_"+z)==null)?"":request.getParameter("domici_otrosDirec_"+z));
			obj.setCodmun((request.getParameter("codmun_otrosDirec_"+z)==null)?"":request.getParameter("codmun_otrosDirec_"+z));
			obj.setLocali((request.getParameter("locali_otrosDirec_"+z)==null)?"":request.getParameter("locali_otrosDirec_"+z));
			obj.setCodpro((request.getParameter("codpro_otrosDirec_"+z)==null)?"":request.getParameter("codpro_otrosDirec_"+z));
			obj.setCodpst((request.getParameter("codpst_otrosDirec_"+z)==null)?"":request.getParameter("codpst_otrosDirec_"+z));
			obj.setPais((request.getParameter("pais_otrosDirec_"+z)==null)?"":request.getParameter("pais_otrosDirec_"+z));
			obj.setProfesi((request.getParameter("profesi_otrosDirec_"+z)==null)?"":request.getParameter("profesi_otrosDirec_"+z));
			obj.setCurso((request.getParameter("curso_otrosDirec_"+z)==null)?"":request.getParameter("curso_otrosDirec_"+z));
			obj.setDenCurso((request.getParameter("denCurso_otrosDirec_"+z)==null)?"":request.getParameter("denCurso_otrosDirec_"+z));
			obj.setFecSus((request.getParameter("fecSus_otrosDirec_"+z)==null)?"":request.getParameter("fecSus_otrosDirec_"+z));
			obj.setFecLeSus((request.getParameter("fecLeSus_otrosDirec_"+z)==null)?"":request.getParameter("fecLeSus_otrosDirec_"+z));
			obj.setFecRev((request.getParameter("fecRev_otrosDirec_"+z)==null)?"":request.getParameter("fecRev_otrosDirec_"+z));
			obj.setFecInha((request.getParameter("fecInha_otrosDirec_"+z)==null)?"":request.getParameter("fecInha_otrosDirec_"+z));
			obj.setDurHab((request.getParameter("durHab_otrosDirec_"+z)==null)?"":request.getParameter("durHab_otrosDirec_"+z));
			obj.setSanciones((request.getParameter("sanciones_otrosDirec_"+z)==null)?"":request.getParameter("sanciones_otrosDirec_"+z));
			obj.setAcredita((request.getParameter("acredita_otrosDirec_"+z)==null)?"":request.getParameter("acredita_otrosDirec_"+z));
			obj.setDAcredita((request.getParameter("dAcredita_otrosDirec_"+z)==null)?"":request.getParameter("dAcredita_otrosDirec_"+z));
			obj.setAcreditaH((request.getParameter("acreditaH_otrosDirec_"+z)==null)?"":request.getParameter("acreditaH_otrosDirec_"+z));
			obj.setDAcreditaH((request.getParameter("dAcreditaH_otrosDirec_"+z)==null)?"":request.getParameter("dAcreditaH_otrosDirec_"+z));
			obj.setVinculaciones((request.getParameter("vinculaciones_otrosDirec_"+z)==null)?"":request.getParameter("vinculaciones_otrosDirec_"+z));
			obj.setEnAseAutori((request.getParameter("enAseAutori_otrosDirec_"+z)==null)?"":request.getParameter("enAseAutori_otrosDirec_"+z));
			obj.setIdCargo((request.getParameter("idCargo_otrosDirec_"+z)==null)?"":request.getParameter("idCargo_otrosDirec_"+z));
			obj.setFechNom((request.getParameter("fechNom_otrosDirec_"+z)==null)?"":request.getParameter("fechNom_otrosDirec_"+z));
			obj.setFecCese((request.getParameter("fecCese_otrosDirec_"+z)==null)?"":request.getParameter("fecCese_otrosDirec_"+z));
						
			objListas.getListaOtrosDirec().add(obj);	
		}
		obj = new P06B24T00Datatype();
		
		obj.setnExpediente((z+1)+"");
		obj.setIdentificador("");
		obj.setTipo("");
		obj.setNombre("");
		obj.setApe1("");
		obj.setApe2("");
		obj.setDomici("");
		obj.setCodmun("");
		obj.setLocali("");
		obj.setCodpro("");
		obj.setCodpst("");
		obj.setPais("");
		obj.setProfesi("");
		obj.setCurso("");
		obj.setDenCurso("");
		obj.setFecSus("");
		obj.setFecLeSus("");
		obj.setFecRev("");
		obj.setFecInha("");
		obj.setDurHab("");
		obj.setSanciones("");
		obj.setAcredita("");
		obj.setDAcredita("");
		obj.setAcreditaH("");
		obj.setDAcreditaH("");
		obj.setVinculaciones("");
		obj.setEnAseAutori("");
		obj.setIdCargo("");
		obj.setFechNom("");
		obj.setFecCese("");
		
		objListas.getListaOtrosDirec().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de rganos y eliminamos el valor seleccionado
	private void eliminarFromListaOtrosDirec (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		String idCargoDelete = (request.getParameter("idCargoDelete")==null)?"":request.getParameter("idCargoDelete");
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Recorro la lista de rganos y elimino aquel cuyo identificador 
		//coincida con idTablaDelete
		for(int i=0;i<objListas.getListaOtrosDirec().size();i++){
			P06B24T00Datatype obj = (P06B24T00Datatype)objListas.getListaOtrosDirec().get(i);
			if(obj.getIdentificador()!=null && obj.getIdentificador().equals(idTablaDelete) && idCargoDelete.equals(obj.getIdCargo())){
				objListas.getListaOtrosDirec().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	//FIN OTROS DIRECCION
	
	
	//SUCURSALES
	//Recogemos la lista de socios y las actualizamos con los nuevos valores
	private void actualizarListaSucursales (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir una sucursal
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		P06B25T00Datatype obj = null;
		int numSucursales = objListas.getListaSucursales().size();
//		objListas.getListaSucursales().clear();
		int z=0;
		for(z=0;z<numSucursales;z++){
//			obj = new P06B25T00Datatype();
			obj = (P06B25T00Datatype)objListas.getListaSucursales().get(z);

			obj.setNumExp(z+"");
			obj.setDomici((request.getParameter("domici_sucursal_"+z)==null)?"":request.getParameter("domici_sucursal_"+z));
			obj.setCorr((request.getParameter("corr_sucursal_"+z)==null)?"":request.getParameter("corr_sucursal_"+z));
			obj.setCodmun((request.getParameter("codmun_sucursal_"+z)==null)?"":request.getParameter("codmun_sucursal_"+z));
			obj.setLocali((request.getParameter("locali_sucursal_"+z)==null)?"":request.getParameter("locali_sucursal_"+z));
			obj.setCodpro((request.getParameter("codpro_sucursal_"+z)==null)?"":request.getParameter("codpro_sucursal_"+z));
			obj.setCodpst((request.getParameter("codpst_sucursal_"+z)==null)?"":request.getParameter("codpst_sucursal_"+z));
			obj.setFax1((request.getParameter("fax1_sucursal_"+z)==null)?"":request.getParameter("fax1_sucursal_"+z));
			obj.setFax2((request.getParameter("fax2_sucursal_"+z)==null)?"":request.getParameter("fax2_sucursal_"+z));
			obj.setMail((request.getParameter("mail_sucursal_"+z)==null)?"":request.getParameter("mail_sucursal_"+z));
			obj.setTelefoc((request.getParameter("telefoc_sucursal_"+z)==null)?"":request.getParameter("telefoc_sucursal_"+z));
			obj.setTelefom((request.getParameter("telefom_sucursal_"+z)==null)?"":request.getParameter("telefom_sucursal_"+z));
			obj.setTelefot((request.getParameter("telefot_sucursal_"+z)==null)?"":request.getParameter("telefot_sucursal_"+z));
			obj.setWeb((request.getParameter("web_sucursal_"+z)==null)?"":request.getParameter("web_sucursal_"+z));
//			objListas.getListaSucursales().add(obj);	
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de sucursales y las actualizamos con los nuevos valores
	private void anadirToListaSucursales (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un socio
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B25T00Datatype obj = null;
		int numSucursales = objListas.getListaSucursales().size();
		objListas.getListaSucursales().clear();
		int z=0;
		for(z=0;z<numSucursales;z++){
			obj = new P06B25T00Datatype();
						
			obj.setNumExp(z+"");
			obj.setDomici((request.getParameter("domici_sucursal_"+z)==null)?"":request.getParameter("domici_sucursal_"+z));
			
			//Al campo corr (correlativo) se le asigna el contador, que se usar junto con el boton (-) para saber que registro de la tabla borrar.
			//Pero a la hora de insertar en base de datos, se le dar el valor correcto a este campo 'corr'
			obj.setCorr(z+"");
			obj.setCodmun((request.getParameter("codmun_sucursal_"+z)==null)?"":request.getParameter("codmun_sucursal_"+z));
			obj.setLocali((request.getParameter("locali_sucursal_"+z)==null)?"":request.getParameter("locali_sucursal_"+z));
			obj.setCodpro((request.getParameter("codpro_sucursal_"+z)==null)?"":request.getParameter("codpro_sucursal_"+z));
			obj.setCodpst((request.getParameter("codpst_sucursal_"+z)==null)?"":request.getParameter("codpst_sucursal_"+z));
			obj.setFax1((request.getParameter("fax1_sucursal_"+z)==null)?"":request.getParameter("fax1_sucursal_"+z));
			obj.setFax2((request.getParameter("fax2_sucursal_"+z)==null)?"":request.getParameter("fax2_sucursal_"+z));
			obj.setMail((request.getParameter("mail_sucursal_"+z)==null)?"":request.getParameter("mail_sucursal_"+z));
			obj.setTelefoc((request.getParameter("telefoc_sucursal_"+z)==null)?"":request.getParameter("telefoc_sucursal_"+z));
			obj.setTelefom((request.getParameter("telefom_sucursal_"+z)==null)?"":request.getParameter("telefom_sucursal_"+z));
			obj.setTelefot((request.getParameter("telefot_sucursal_"+z)==null)?"":request.getParameter("telefot_sucursal_"+z));
			obj.setWeb((request.getParameter("web_sucursal_"+z)==null)?"":request.getParameter("web_sucursal_"+z));
			
			objListas.getListaSucursales().add(obj);	
		}
		obj = new P06B25T00Datatype();
		
		obj.setNumExp((z+1)+"");
		obj.setDomici("");
		obj.setCorr((z+1)+"");
		obj.setCodmun("");
		obj.setLocali("");
		obj.setCodpro("");
		obj.setCodpst("");
		obj.setFax1("");
		obj.setFax2("");
		obj.setMail("");
		obj.setTelefoc("");
		obj.setTelefom("");
		obj.setTelefot("");
		obj.setWeb("");
		
		objListas.getListaSucursales().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de sucursales y eliminamos el valor seleccionado
	private void eliminarFromListaSucursales (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Recorro la lista de sucursales y elimino aquella cuyo corr(correlativo) coincida con idTablaDelete
		for(int i=0;i<objListas.getListaSucursales().size();i++){
			P06B25T00Datatype obj = (P06B25T00Datatype)objListas.getListaSucursales().get(i);
			if(obj.getCorr()!=null && obj.getCorr().equals(idTablaDelete)){
				objListas.getListaSucursales().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	//FIN SUCURSALES
	
		
	//DEFENSORES CLIENTE
	//Recogemos la lista de defensores de cliente y las actualizamos con los nuevos valores
	private void actualizarListaDefCliente (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un defensor del cliente
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		P06B29T00Datatype obj = null;
		P06B30T00Datatype objPF = null;
		int numDefCliente = objListas.getListaDefCliente().size();
//		objListas.getListaDefCliente().clear();
		int z=0;
		int numPFDefCliente = 0;
		for(z=0;z<numDefCliente;z++){
			numPFDefCliente = 0;
//			obj = new P06B29T00Datatype();
			obj = (P06B29T00Datatype)objListas.getListaDefCliente().get(z);

			obj.setNumExp(z+"");
			obj.setIdentificador((request.getParameter("identif_defCliente_"+z)==null)?"":request.getParameter("identif_defCliente_"+z));
			obj.setTipo((request.getParameter("tipo_defCliente_"+z)==null)?"":request.getParameter("tipo_defCliente_"+z));
			obj.setRazsoc((request.getParameter("razsoc_defCliente_"+z)==null)?"":request.getParameter("razsoc_defCliente_"+z));
			obj.setNombre((request.getParameter("nombre_defCliente_"+z)==null)?"":request.getParameter("nombre_defCliente_"+z));
			obj.setApe1((request.getParameter("ape1_defCliente_"+z)==null)?"":request.getParameter("ape1_defCliente_"+z));
			obj.setApe2((request.getParameter("ape2_defCliente_"+z)==null)?"":request.getParameter("ape2_defCliente_"+z));
			obj.setDomici((request.getParameter("domici_defCliente_"+z)==null)?"":request.getParameter("domici_defCliente_"+z));
			obj.setCodmun((request.getParameter("codmun_defCliente_"+z)==null)?"":request.getParameter("codmun_defCliente_"+z));
			obj.setLocali((request.getParameter("locali_defCliente_"+z)==null)?"":request.getParameter("locali_defCliente_"+z));
			obj.setCodpro((request.getParameter("codpro_defCliente_"+z)==null)?"":request.getParameter("codpro_defCliente_"+z));
			obj.setCodpst((request.getParameter("codpst_defCliente_"+z)==null)?"":request.getParameter("codpst_defCliente_"+z));
			obj.setFax1((request.getParameter("fax1_defCliente_"+z)==null)?"":request.getParameter("fax1_defCliente_"+z));
			obj.setFax2((request.getParameter("fax2_defCliente_"+z)==null)?"":request.getParameter("fax2_defCliente_"+z));
			obj.setMail((request.getParameter("mail_defCliente_"+z)==null)?"":request.getParameter("mail_defCliente_"+z));
			obj.setTelefoc((request.getParameter("telefoc_defCliente_"+z)==null)?"":request.getParameter("telefoc_defCliente_"+z));
			obj.setTelefom((request.getParameter("telefom_defCliente_"+z)==null)?"":request.getParameter("telefom_defCliente_"+z));
			obj.setTelefot((request.getParameter("telefot_defCliente_"+z)==null)?"":request.getParameter("telefot_defCliente_"+z));
			obj.setWeb((request.getParameter("web_defCliente_"+z)==null)?"":request.getParameter("web_defCliente_"+z));
			if (request.getParameter("operacion_defCliente_"+z)!=null){
				obj.setOperacion(Integer.parseInt(request.getParameter("operacion_defCliente_"+z)));				
			}
			if (request.getParameter("aprobado_defCliente_"+z)!=null){
				obj.setAprobado(Integer.parseInt(request.getParameter("aprobado_defCliente_"+z)));				
			}
			//Aprobamos todo
			obj.setAprobado(1);				
			
			//Se carga la lista de personas fsicas que forman el defensor del cliente en caso de que ste sea jurdico
			obj.getListaPF_DefCliente().clear();
			numPFDefCliente = Integer.parseInt((request.getParameter("numPF_defCliente_"+z)==null)?"0":request.getParameter("numPF_defCliente_"+z));
			for(int k=0;k<numPFDefCliente;k++){
				objPF = new P06B30T00Datatype();
			
				objPF.setNumExp(z+"");
				objPF.setIdentificador((request.getParameter("identif_defCliente_"+z)==null)?"":request.getParameter("identif_defCliente_"+z));
				objPF.setIdentificador1((request.getParameter("identif1_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("identif1_PFDefCliente_"+z+"_"+k));				
				objPF.setNombre((request.getParameter("nombre_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("nombre_PFDefCliente_"+z+"_"+k));
				objPF.setApe1((request.getParameter("ape1_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("ape1_PFDefCliente_"+z+"_"+k));
				objPF.setApe2((request.getParameter("ape2_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("ape2_PFDefCliente_"+z+"_"+k));
				objPF.setDomici((request.getParameter("domici_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("domici_PFDefCliente_"+z+"_"+k));
				objPF.setCodmun((request.getParameter("codmun_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("codmun_PFDefCliente_"+z+"_"+k));
				objPF.setLocali((request.getParameter("locali_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("locali_PFDefCliente_"+z+"_"+k));
				objPF.setCodpro((request.getParameter("codpro_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("codpro_PFDefCliente_"+z+"_"+k));
				objPF.setCodpst((request.getParameter("codpst_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("codpst_PFDefCliente_"+z+"_"+k));
				
				obj.getListaPF_DefCliente().add(objPF);
			}
			
//			objListas.getListaDefCliente().add(obj);	
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//DEFENSORES CLIENTE
	//Recogemos la lista de defensores de cliente y las actualizamos con los nuevos valores
	private void inicializarListaDefCliente (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un defensor del cliente
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		objListas.getListaDefCliente().clear();
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de defensores de cliente y las actualizamos con los nuevos valores
	private void anadirToListaDefCliente (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un socio
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B29T00Datatype obj = null;
		P06B30T00Datatype objPF = null;
		int numPFDefCliente = 0;
		int numDefCliente = objListas.getListaDefCliente().size();
		objListas.getListaDefCliente().clear();
		int z=0;
		for(z=0;z<numDefCliente;z++){
			obj = new P06B29T00Datatype();
			
			obj.setNumExp(z+"");
			obj.setIdentificador((request.getParameter("identif_defCliente_"+z)==null)?"":request.getParameter("identif_defCliente_"+z));
			obj.setTipo((request.getParameter("tipo_defCliente_"+z)==null)?"":request.getParameter("tipo_defCliente_"+z));
			obj.setRazsoc((request.getParameter("razsoc_defCliente_"+z)==null)?"":request.getParameter("razsoc_defCliente_"+z));
			obj.setNombre((request.getParameter("nombre_defCliente_"+z)==null)?"":request.getParameter("nombre_defCliente_"+z));
			obj.setApe1((request.getParameter("ape1_defCliente_"+z)==null)?"":request.getParameter("ape1_defCliente_"+z));
			obj.setApe2((request.getParameter("ape2_defCliente_"+z)==null)?"":request.getParameter("ape2_defCliente_"+z));
			obj.setDomici((request.getParameter("domici_defCliente_"+z)==null)?"":request.getParameter("domici_defCliente_"+z));
			obj.setCodmun((request.getParameter("codmun_defCliente_"+z)==null)?"":request.getParameter("codmun_defCliente_"+z));
			obj.setLocali((request.getParameter("locali_defCliente_"+z)==null)?"":request.getParameter("locali_defCliente_"+z));
			obj.setCodpro((request.getParameter("codpro_defCliente_"+z)==null)?"":request.getParameter("codpro_defCliente_"+z));
			obj.setCodpst((request.getParameter("codpst_defCliente_"+z)==null)?"":request.getParameter("codpst_defCliente_"+z));
			obj.setFax1((request.getParameter("fax1_defCliente_"+z)==null)?"":request.getParameter("fax1_defCliente_"+z));
			obj.setFax2((request.getParameter("fax2_defCliente_"+z)==null)?"":request.getParameter("fax2_defCliente_"+z));
			obj.setMail((request.getParameter("mail_defCliente_"+z)==null)?"":request.getParameter("mail_defCliente_"+z));
			obj.setTelefoc((request.getParameter("telefoc_defCliente_"+z)==null)?"":request.getParameter("telefoc_defCliente_"+z));
			obj.setTelefom((request.getParameter("telefom_defCliente_"+z)==null)?"":request.getParameter("telefom_defCliente_"+z));
			obj.setTelefot((request.getParameter("telefot_defCliente_"+z)==null)?"":request.getParameter("telefot_defCliente_"+z));
			obj.setWeb((request.getParameter("web_defCliente_"+z)==null)?"":request.getParameter("web_defCliente_"+z));
						
			//Se carga la lista de personas fsicas que forman el defensor del cliente en caso de que ste sea jurdico
			obj.getListaPF_DefCliente().clear();
			numPFDefCliente = Integer.parseInt((request.getParameter("numPF_defCliente_"+z)==null)?"0":request.getParameter("numPF_defCliente_"+z));
			for(int k=0;k<numPFDefCliente;k++){
				objPF = new P06B30T00Datatype();
			
				objPF.setNumExp(z+"");
				objPF.setIdentificador((request.getParameter("identif_defCliente_"+z)==null)?"":request.getParameter("identif_defCliente_"+z));
				objPF.setIdentificador1((request.getParameter("identif1_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("identif1_PFDefCliente_"+z+"_"+k));				
				objPF.setNombre((request.getParameter("nombre_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("nombre_PFDefCliente_"+z+"_"+k));
				objPF.setApe1((request.getParameter("ape1_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("ape1_PFDefCliente_"+z+"_"+k));
				objPF.setApe2((request.getParameter("ape2_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("ape2_PFDefCliente_"+z+"_"+k));
				objPF.setDomici((request.getParameter("domici_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("domici_PFDefCliente_"+z+"_"+k));
				objPF.setCodmun((request.getParameter("codmun_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("codmun_PFDefCliente_"+z+"_"+k));
				objPF.setLocali((request.getParameter("locali_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("locali_PFDefCliente_"+z+"_"+k));
				objPF.setCodpro((request.getParameter("codpro_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("codpro_PFDefCliente_"+z+"_"+k));
				objPF.setCodpst((request.getParameter("codpst_PFDefCliente_"+z+"_"+k)==null)?"":request.getParameter("codpst_PFDefCliente_"+z+"_"+k));
				
				obj.getListaPF_DefCliente().add(objPF);
			}
			objListas.getListaDefCliente().add(obj);	
		}
		obj = new P06B29T00Datatype();
		
		obj.setNumExp((z+1)+"");
		obj.setIdentificador("");
		obj.setTipo("");
		obj.setRazsoc("");
		obj.setNombre("");
		obj.setApe1("");
		obj.setApe2("");
		obj.setDomici("");
		obj.setCodmun("");
		obj.setLocali("");
		obj.setCodpro("");
		obj.setCodpst("");
		obj.setFax1("");
		obj.setFax2("");
		obj.setMail("");
		obj.setTelefoc("");
		obj.setTelefom("");
		obj.setTelefot("");
		obj.setWeb("");
		
		objListas.getListaDefCliente().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de defensores cliente y eliminamos el valor seleccionado
	private void eliminarFromListaDefCliente (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Recorro la lista de defensores cliente y elimino aquella cuyo identificador coincida con idTablaDelete
		for(int i=0;i<objListas.getListaDefCliente().size();i++){
			P06B29T00Datatype obj = (P06B29T00Datatype)objListas.getListaDefCliente().get(i);
			if(obj.getIdentificador()!=null && obj.getIdentificador().equals(idTablaDelete)){
				objListas.getListaDefCliente().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	//FIN DEFENSORES CLIENTE
	
	
	//PERSONAS FISICAS del DEFENSOR CLIENTE
	//Recogemos la lista de defensores de cliente y actualizamos la lista de personas fsicas del defensor indicado mediante "corrDefCliente"
	private void anadirToListaPFDefCliente (HttpServletRequest request) throws Exception {
		String corrDefCliente = (request.getParameter("corrDefCliente")==null)?"":request.getParameter("corrDefCliente");
		//Se ha dado a aadir una persona fsica dentro de un defensor de cliente jurdico

		if (corrDefCliente != null && !corrDefCliente.equals("")){
			P06BCorredorListasAux objListas = null;
			if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
				objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
			}else{
				objListas = new P06BCorredorListasAux();
			}
			
			//Aado un objeto vaco al final de la lista de personas fsicas del defensor que se indica mediante "corrDefCliente"
			P06B30T00Datatype objPF = new P06B30T00Datatype();				
			//objPF.setNumExp((z+1)+"");
			objPF.setNumExp("");
			objPF.setIdentificador("");
			objPF.setIdentificador1("");				
			objPF.setNombre("");
			objPF.setApe1("");
			objPF.setApe2("");
			objPF.setDomici("");
			objPF.setCodmun("");
			objPF.setLocali("");
			objPF.setCodpro("");
			objPF.setCodpst("");
			
			//TODO cuidado!!!! , igual no coincide con el correlativo
			if (Integer.parseInt(corrDefCliente) < objListas.getListaDefCliente().size()){
				((P06B29T00Datatype)objListas.getListaDefCliente().get(Integer.parseInt(corrDefCliente))).getListaPF_DefCliente().add(objPF);
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
			}
		}
	}
	
	//Recogemos la lista de defensores cliente y eliminamos la persona fsica indica mediante "idTabladelte"
	//del defensor indicado mediante "corrDefCliente"
	private void eliminarFromListaPFDefCliente (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		String corrDefCliente = (request.getParameter("corrDefCliente")==null)?"":request.getParameter("corrDefCliente");
		if (corrDefCliente != null && !corrDefCliente.equals("")){
			P06BCorredorListasAux objListas = null;
			if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
				objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
			}else{
				objListas = new P06BCorredorListasAux();
			}
			//Recorro la lista de personas fsicas del defensor de cliente indicado y elimino aquella cuyo identificador coincida con idTablaDelete
			if (Integer.parseInt(corrDefCliente) < objListas.getListaDefCliente().size()){
				
				for(int i=0;i<((P06B29T00Datatype)objListas.getListaDefCliente().get(Integer.parseInt(corrDefCliente))).getListaPF_DefCliente().size();i++){					
					P06B30T00Datatype obj = (P06B30T00Datatype)((P06B29T00Datatype)objListas.getListaDefCliente().get(Integer.parseInt(corrDefCliente))).getListaPF_DefCliente().get(i);					
					if(obj.getIdentificador1()!=null && obj.getIdentificador1().equals(idTablaDelete)){						
						((P06B29T00Datatype)objListas.getListaDefCliente().get(Integer.parseInt(corrDefCliente))).getListaPF_DefCliente().remove(i);
						break;
					}
				}
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
			}
		}
	}
	//FIN PERSONAS FISICAS del DEFENSOR CLIENTE
	
	
	//ATENCION AL CLIENTE
	//Recogemos la lista de departametnos de atencion al cliente y las actualizamos con los nuevos valores
	private void actualizarListaDepAtCliente (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un departamento de atencin al cliente
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		P06B26T00Datatype obj = null;
		P06B27T00Datatype objPF = null;
		P06B28T00Datatype objResp = null;
		int numDepAtCliente = objListas.getListaDepAtCliente().size();
//		objListas.getListaDepAtCliente().clear();
		int z=0;
		int numPFDepAtCliente = 0;
		int numRespDepAtCliente = 0;
		for(z=0;z<numDepAtCliente;z++){
			numPFDepAtCliente = 0;
			numRespDepAtCliente = 0;
//			obj = new P06B26T00Datatype();
			obj = (P06B26T00Datatype)objListas.getListaDepAtCliente().get(z);

			obj.setNumExp(z+"");
			obj.setIdentificador((request.getParameter("identif_depAtCliente_"+z)==null)?"":request.getParameter("identif_depAtCliente_"+z));
			obj.setTipo((request.getParameter("tipo_depAtCliente_"+z)==null)?"":request.getParameter("tipo_depAtCliente_"+z));
			obj.setClase((request.getParameter("clase_depAtCliente_"+z)==null)?"":request.getParameter("clase_depAtCliente_"+z));
			obj.setRazsoc((request.getParameter("razsoc_depAtCliente_"+z)==null)?"":request.getParameter("razsoc_depAtCliente_"+z));
			obj.setNombre((request.getParameter("nombre_depAtCliente_"+z)==null)?"":request.getParameter("nombre_depAtCliente_"+z));
			obj.setApe1((request.getParameter("ape1_depAtCliente_"+z)==null)?"":request.getParameter("ape1_depAtCliente_"+z));
			obj.setApe2((request.getParameter("ape2_depAtCliente_"+z)==null)?"":request.getParameter("ape2_depAtCliente_"+z));
			obj.setDomici((request.getParameter("domici_depAtCliente_"+z)==null)?"":request.getParameter("domici_depAtCliente_"+z));
			obj.setCodmun((request.getParameter("codmun_depAtCliente_"+z)==null)?"":request.getParameter("codmun_depAtCliente_"+z));
			obj.setLocali((request.getParameter("locali_depAtCliente_"+z)==null)?"":request.getParameter("locali_depAtCliente_"+z));
			obj.setCodpro((request.getParameter("codpro_depAtCliente_"+z)==null)?"":request.getParameter("codpro_depAtCliente_"+z));
			obj.setCodpst((request.getParameter("codpst_depAtCliente_"+z)==null)?"":request.getParameter("codpst_depAtCliente_"+z));
			if (request.getParameter("operacion_depAtCliente_"+z)!=null){
				obj.setOperacion(Integer.parseInt(request.getParameter("operacion_depAtCliente_"+z)));				
			}
			if (request.getParameter("aprobado_depAtCliente_"+z)!=null){
				obj.setAprobado(Integer.parseInt(request.getParameter("aprobado_depAtCliente_"+z)));				
			}
			//Aprobamos todo
			obj.setAprobado(1);				
			

			//Se carga la lista de personas fsicas que forman el departamento de atencin al cliente en caso de que ste sea jurdico
			obj.getListaPF_DepAtCliente().clear();
			numPFDepAtCliente = Integer.parseInt((request.getParameter("numPF_depAtCliente_"+z)==null)?"0":request.getParameter("numPF_depAtCliente_"+z));
			for(int k=0;k<numPFDepAtCliente;k++){
				objPF = new P06B27T00Datatype();
			
				objPF.setNumExp(z+"");
				objPF.setIdentificador((request.getParameter("identif_depAtCliente_"+z)==null)?"":request.getParameter("identif_depAtCliente_"+z));
				objPF.setIdentificador1((request.getParameter("identif1_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("identif1_PFDepAtCliente_"+z+"_"+k));				
				objPF.setNombre((request.getParameter("nombre_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("nombre_PFDepAtCliente_"+z+"_"+k));
				objPF.setApe1((request.getParameter("ape1_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("ape1_PFDepAtCliente_"+z+"_"+k));
				objPF.setApe2((request.getParameter("ape2_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("ape2_PFDepAtCliente_"+z+"_"+k));
				objPF.setDomici((request.getParameter("domici_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("domici_PFDepAtCliente_"+z+"_"+k));
				objPF.setCodmun((request.getParameter("codmun_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codmun_PFDepAtCliente_"+z+"_"+k));
				objPF.setLocali((request.getParameter("locali_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("locali_PFDepAtCliente_"+z+"_"+k));
				objPF.setCodpro((request.getParameter("codpro_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codpro_PFDepAtCliente_"+z+"_"+k));
				objPF.setCodpst((request.getParameter("codpst_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codpst_PFDepAtCliente_"+z+"_"+k));
				
				obj.getListaPF_DepAtCliente().add(objPF);
			}
			
			
			//Se carga la lista de responsables del departamento de atencin al cliente
			obj.getListaRespDepAtCl().clear();
			numRespDepAtCliente = Integer.parseInt((request.getParameter("numResp_depAtCliente_"+z)==null)?"0":request.getParameter("numResp_depAtCliente_"+z));
			for(int k=0;k<numRespDepAtCliente;k++){
				objResp = new P06B28T00Datatype();

				objResp.setNumExp(z+"");
				objResp.setIdentificador((request.getParameter("identif_depAtCliente_"+z)==null)?"":request.getParameter("identif_depAtCliente_"+z));
				objResp.setIdentificador1((request.getParameter("identif1_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("identif1_respDepAtCliente_"+z+"_"+k));
				objResp.setTipo((request.getParameter("tipo_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("tipo_respDepAtCliente_"+z+"_"+k));
				objResp.setRazsoc((request.getParameter("razsoc_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("razsoc_respDepAtCliente_"+z+"_"+k));
				objResp.setNombre((request.getParameter("nombre_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("nombre_respDepAtCliente_"+z+"_"+k));
				objResp.setApe1((request.getParameter("ape1_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("ape1_respDepAtCliente_"+z+"_"+k));
				objResp.setApe2((request.getParameter("ape2_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("ape2_respDepAtCliente_"+z+"_"+k));
				objResp.setDomici((request.getParameter("domici_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("domici_respDepAtCliente_"+z+"_"+k));
				objResp.setCodmun((request.getParameter("codmun_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codmun_respDepAtCliente_"+z+"_"+k));
				objResp.setLocali((request.getParameter("locali_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("locali_respDepAtCliente_"+z+"_"+k));
				objResp.setCodpro((request.getParameter("codpro_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codpro_respDepAtCliente_"+z+"_"+k));
				objResp.setCodpst((request.getParameter("codpst_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codpst_respDepAtCliente_"+z+"_"+k));
				objResp.setTelefoc((request.getParameter("telefoc_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("telefoc_respDepAtCliente_"+z+"_"+k));
				objResp.setTelefom((request.getParameter("telefom_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("telefom_respDepAtCliente_"+z+"_"+k));
				objResp.setTelefot((request.getParameter("telefot_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("telefot_respDepAtCliente_"+z+"_"+k));
				objResp.setFax1((request.getParameter("fax1_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("fax1_respDepAtCliente_"+z+"_"+k));
				objResp.setFax2((request.getParameter("fax2_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("fax2_respDepAtCliente_"+z+"_"+k));
				objResp.setMail((request.getParameter("mail_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("mail_respDepAtCliente_"+z+"_"+k));
				objResp.setWeb((request.getParameter("web_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("web_respDepAtCliente_"+z+"_"+k));
							
				obj.getListaRespDepAtCl().add(objResp);
			}
			
			
//			objListas.getListaDepAtCliente().add(obj);	
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//ATENCION AL CLIENTE
	//Recogemos la lista de departametnos de atencion al cliente y las actualizamos con los nuevos valores
	private void inicializarListaDepAtCliente (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un departamento de atencin al cliente
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		objListas.getListaDepAtCliente().clear();
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de departamentos de atencion al cliente y las actualizamos con los nuevos valores
	private void anadirToListaDepAtCliente (HttpServletRequest request) throws Exception {
		//Se ha dado a aadir un departamento de atencin al cliente
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Aado un objeto vaco al final de la lista
		P06B26T00Datatype obj = null;
		P06B27T00Datatype objPF = null;
		P06B28T00Datatype objResp = null;
		int numPFDepAtCliente = 0;
		int numRespDepAtCliente = 0;
		int numDepAtCliente = objListas.getListaDepAtCliente().size();
		objListas.getListaDepAtCliente().clear();
		int z=0;
		for(z=0;z<numDepAtCliente;z++){
			numPFDepAtCliente = 0;
			numRespDepAtCliente = 0;
			obj = new P06B26T00Datatype();
			
			obj.setNumExp(z+"");
			obj.setIdentificador((request.getParameter("identif_depAtCliente_"+z)==null)?"":request.getParameter("identif_depAtCliente_"+z));
			obj.setTipo((request.getParameter("tipo_depAtCliente_"+z)==null)?"":request.getParameter("tipo_depAtCliente_"+z));
			obj.setClase((request.getParameter("clase_depAtCliente_"+z)==null)?"":request.getParameter("clase_depAtCliente_"+z));
			obj.setRazsoc((request.getParameter("razsoc_depAtCliente_"+z)==null)?"":request.getParameter("razsoc_depAtCliente_"+z));
			obj.setNombre((request.getParameter("nombre_depAtCliente_"+z)==null)?"":request.getParameter("nombre_depAtCliente_"+z));
			obj.setApe1((request.getParameter("ape1_depAtCliente_"+z)==null)?"":request.getParameter("ape1_depAtCliente_"+z));
			obj.setApe2((request.getParameter("ape2_depAtCliente_"+z)==null)?"":request.getParameter("ape2_depAtCliente_"+z));
			obj.setDomici((request.getParameter("domici_depAtCliente_"+z)==null)?"":request.getParameter("domici_depAtCliente_"+z));
			obj.setCodmun((request.getParameter("codmun_depAtCliente_"+z)==null)?"":request.getParameter("codmun_depAtCliente_"+z));
			obj.setLocali((request.getParameter("locali_depAtCliente_"+z)==null)?"":request.getParameter("locali_depAtCliente_"+z));
			obj.setCodpro((request.getParameter("codpro_depAtCliente_"+z)==null)?"":request.getParameter("codpro_depAtCliente_"+z));
			obj.setCodpst((request.getParameter("codpst_depAtCliente_"+z)==null)?"":request.getParameter("codpst_depAtCliente_"+z));
			
			//Se carga la lista de personas fsicas que forman el departamento de atencin al cliente en caso de que ste sea jurdico
			obj.getListaPF_DepAtCliente().clear();
			numPFDepAtCliente = Integer.parseInt((request.getParameter("numPF_depAtCliente_"+z)==null)?"0":request.getParameter("numPF_depAtCliente_"+z));
			for(int k=0;k<numPFDepAtCliente;k++){
				objPF = new P06B27T00Datatype();
			
				objPF.setNumExp(z+"");
				objPF.setIdentificador((request.getParameter("identif_depAtCliente_"+z)==null)?"":request.getParameter("identif_depAtCliente_"+z));
				objPF.setIdentificador1((request.getParameter("identif1_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("identif1_PFDepAtCliente_"+z+"_"+k));				
				objPF.setNombre((request.getParameter("nombre_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("nombre_PFDepAtCliente_"+z+"_"+k));
				objPF.setApe1((request.getParameter("ape1_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("ape1_PFDepAtCliente_"+z+"_"+k));
				objPF.setApe2((request.getParameter("ape2_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("ape2_PFDepAtCliente_"+z+"_"+k));
				objPF.setDomici((request.getParameter("domici_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("domici_PFDepAtCliente_"+z+"_"+k));
				objPF.setCodmun((request.getParameter("codmun_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codmun_PFDepAtCliente_"+z+"_"+k));
				objPF.setLocali((request.getParameter("locali_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("locali_PFDepAtCliente_"+z+"_"+k));
				objPF.setCodpro((request.getParameter("codpro_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codpro_PFDepAtCliente_"+z+"_"+k));
				objPF.setCodpst((request.getParameter("codpst_PFDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codpst_PFDepAtCliente_"+z+"_"+k));
				
				obj.getListaPF_DepAtCliente().add(objPF);
			}
			
			
			//Se carga la lista de responsables del departamento de atencin al cliente
			obj.getListaRespDepAtCl().clear();
			numRespDepAtCliente = Integer.parseInt((request.getParameter("numResp_depAtCliente_"+z)==null)?"0":request.getParameter("numResp_depAtCliente_"+z));
			for(int k=0;k<numRespDepAtCliente;k++){
				objResp = new P06B28T00Datatype();

				objResp.setNumExp(z+"");
				objResp.setIdentificador((request.getParameter("identif_depAtCliente_"+z)==null)?"":request.getParameter("identif_depAtCliente_"+z));
				objResp.setIdentificador1((request.getParameter("identif1_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("identif1_respDepAtCliente_"+z+"_"+k));
				objResp.setTipo((request.getParameter("tipo_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("tipo_respDepAtCliente_"+z+"_"+k));
				objResp.setRazsoc((request.getParameter("razsoc_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("razsoc_respDepAtCliente_"+z+"_"+k));
				objResp.setNombre((request.getParameter("nombre_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("nombre_respDepAtCliente_"+z+"_"+k));
				objResp.setApe1((request.getParameter("ape1_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("ape1_respDepAtCliente_"+z+"_"+k));
				objResp.setApe2((request.getParameter("ape2_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("ape2_respDepAtCliente_"+z+"_"+k));
				objResp.setDomici((request.getParameter("domici_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("domici_respDepAtCliente_"+z+"_"+k));
				objResp.setCodmun((request.getParameter("codmun_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codmun_respDepAtCliente_"+z+"_"+k));
				objResp.setLocali((request.getParameter("locali_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("locali_respDepAtCliente_"+z+"_"+k));
				objResp.setCodpro((request.getParameter("codpro_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codpro_respDepAtCliente_"+z+"_"+k));
				objResp.setCodpst((request.getParameter("codpst_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("codpst_respDepAtCliente_"+z+"_"+k));
				objResp.setTelefoc((request.getParameter("telefoc_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("telefoc_respDepAtCliente_"+z+"_"+k));
				objResp.setTelefom((request.getParameter("telefom_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("telefom_respDepAtCliente_"+z+"_"+k));
				objResp.setTelefot((request.getParameter("telefot_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("telefot_respDepAtCliente_"+z+"_"+k));
				objResp.setFax1((request.getParameter("fax1_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("fax1_respDepAtCliente_"+z+"_"+k));
				objResp.setFax2((request.getParameter("fax2_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("fax2_respDepAtCliente_"+z+"_"+k));
				objResp.setMail((request.getParameter("mail_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("mail_respDepAtCliente_"+z+"_"+k));
				objResp.setWeb((request.getParameter("web_respDepAtCliente_"+z+"_"+k)==null)?"":request.getParameter("web_respDepAtCliente_"+z+"_"+k));
							
				obj.getListaRespDepAtCl().add(objResp);
			}
			
			
			objListas.getListaDepAtCliente().add(obj);	
		}
		obj = new P06B26T00Datatype();
		
		obj.setNumExp((z+1)+"");
		obj.setIdentificador("");
		obj.setTipo("");
		obj.setClase("");
		obj.setRazsoc("");
		obj.setNombre("");
		obj.setApe1("");
		obj.setApe2("");
		obj.setDomici("");
		obj.setCodmun("");
		obj.setLocali("");
		obj.setCodpro("");
		obj.setCodpst("");
		
		objListas.getListaDepAtCliente().add(obj);
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	
	//Recogemos la lista de departamentos de atencin al cliente y eliminamos el valor seleccionado
	private void eliminarFromListaDepAtCliente (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//Recorro la lista de departamentos de atencin al cliente y elimino aquella cuyo identificador coincida con idTablaDelete
		for(int i=0;i<objListas.getListaDepAtCliente().size();i++){
			P06B26T00Datatype obj = (P06B26T00Datatype)objListas.getListaDepAtCliente().get(i);
			if(obj.getIdentificador()!=null && obj.getIdentificador().equals(idTablaDelete)){
				objListas.getListaDepAtCliente().remove(i);
				break;
			}
		}
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
	}
	//FIN DEPARTAMENTO ATENCION CLIENTE
	
	
	//PERSONAS FISICAS del DEPARTAMENTO de ATENCION CLIENTE
	//Recogemos la lista de departamentos de atencin al cliente y actualizamos la lista de personas fsicas del departamento indicado mediante "corrDefCliente"
	private void anadirToListaPFDepAtCliente (HttpServletRequest request) throws Exception {
		String corrDefCliente = (request.getParameter("corrDefCliente")==null)?"":request.getParameter("corrDefCliente");
		//Se ha dado a aadir una persona fsica dentro de un departamento de atencin al cliente jurdico

		if (corrDefCliente != null && !corrDefCliente.equals("")){
			P06BCorredorListasAux objListas = null;
			if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
				objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
			}else{
				objListas = new P06BCorredorListasAux();
			}
			
			//Aado un objeto vaco al final de la lista de personas fsicas del departamento que se indica mediante "corrDefCliente"
			P06B27T00Datatype objPF = new P06B27T00Datatype();				
			//objPF.setNumExp((z+1)+"");
			objPF.setNumExp("");
			objPF.setIdentificador("");
			objPF.setIdentificador1("");				
			objPF.setNombre("");
			objPF.setApe1("");
			objPF.setApe2("");
			objPF.setDomici("");
			objPF.setCodmun("");
			objPF.setLocali("");
			objPF.setCodpro("");
			objPF.setCodpst("");
			
			//TODO cuidado!!!! , igual no coincide con el correlativo
			if (Integer.parseInt(corrDefCliente) < objListas.getListaDepAtCliente().size()){
				((P06B26T00Datatype)objListas.getListaDepAtCliente().get(Integer.parseInt(corrDefCliente))).getListaPF_DepAtCliente().add(objPF);
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
			}
		}
	}
	
	//Recogemos la lista de departamentos de atencin al cliente y eliminamos la persona fsica indicada mediante "idTabladelte"
	//del departamento indicado mediante "corrDefCliente"
	private void eliminarFromListaPFDepAtCliente (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		String corrDefCliente = (request.getParameter("corrDefCliente")==null)?"":request.getParameter("corrDefCliente");
		if (corrDefCliente != null && !corrDefCliente.equals("")){
			P06BCorredorListasAux objListas = null;
			if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
				objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
			}else{
				objListas = new P06BCorredorListasAux();
			}
			//Recorro la lista de personas fsicas del departamento de atencin al cliente indicado y elimino aquella cuyo identificador coincida con idTablaDelete
			if (Integer.parseInt(corrDefCliente) < objListas.getListaDepAtCliente().size()){
				for(int i=0;i<((P06B26T00Datatype)objListas.getListaDepAtCliente().get(Integer.parseInt(corrDefCliente))).getListaPF_DepAtCliente().size();i++){					
					P06B27T00Datatype obj = (P06B27T00Datatype)((P06B26T00Datatype)objListas.getListaDepAtCliente().get(Integer.parseInt(corrDefCliente))).getListaPF_DepAtCliente().get(i);					
					if(obj.getIdentificador1()!=null && obj.getIdentificador1().equals(idTablaDelete)){						
						((P06B26T00Datatype)objListas.getListaDepAtCliente().get(Integer.parseInt(corrDefCliente))).getListaPF_DepAtCliente().remove(i);
						break;
					}
				}
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
			}
		}
	}
	//FIN PERSONAS FISICAS del DEPARTAMENTO de ATENCION CLIENTE
	
	
	//RESPONSABLES del DEPARTAMENTO de ATENCION CLIENTE
	//Recogemos la lista de departamentos de atencin al cliente y actualizamos la lista de responsables del departamento indicado mediante "corrDefCliente"
	private void anadirToListaRespDepAtCliente (HttpServletRequest request) throws Exception {
		String corrDefCliente = (request.getParameter("corrDefCliente")==null)?"":request.getParameter("corrDefCliente");
		//Se ha dado a aadir un responsable dentro de un departamento de atencin al cliente

		if (corrDefCliente != null && !corrDefCliente.equals("")){
			P06BCorredorListasAux objListas = null;
			if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
				objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
			}else{
				objListas = new P06BCorredorListasAux();
			}
			
			//Aado un objeto vaco al final de la lista de responsables del departamento que se indica mediante "corrDefCliente"
			P06B28T00Datatype objResp = new P06B28T00Datatype();				
			//objResp.setNumExp((z+1)+"");
			objResp.setNumExp("");
			objResp.setIdentificador("");
			objResp.setIdentificador1("");
			objResp.setTipo("");
			objResp.setRazsoc("");
			objResp.setNombre("");
			objResp.setApe1("");
			objResp.setApe2("");
			objResp.setDomici("");
			objResp.setCodmun("");
			objResp.setLocali("");
			objResp.setCodpro("");
			objResp.setCodpst("");
			objResp.setTelefoc("");
			objResp.setTelefom("");
			objResp.setTelefot("");
			objResp.setFax1("");
			objResp.setFax2("");
			objResp.setMail("");
			objResp.setWeb("");
			
			//TODO cuidado!!!! , igual no coincide con el correlativo
			if (Integer.parseInt(corrDefCliente) < objListas.getListaDepAtCliente().size()){
				((P06B26T00Datatype)objListas.getListaDepAtCliente().get(Integer.parseInt(corrDefCliente))).getListaRespDepAtCl().add(objResp);
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
			}
		}
	}
	
	//Recogemos la lista de departamentos de atencin al cliente y eliminamos el responsable indicado mediante "idTabladelte"
	//del departamento indicado mediante "corrDefCliente"
	private void eliminarFromListaRespDepAtCliente (HttpServletRequest request) throws Exception {
		String idTablaDelete = (request.getParameter("idTablaDelete")==null)?"":request.getParameter("idTablaDelete");
		String corrDefCliente = (request.getParameter("corrDefCliente")==null)?"":request.getParameter("corrDefCliente");
		if (corrDefCliente != null && !corrDefCliente.equals("")){
			P06BCorredorListasAux objListas = null;
			if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
				objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
			}else{
				objListas = new P06BCorredorListasAux();
			}
			//Recorro la lista de responsables del departamento de atencin al cliente indicado y elimino aquella cuyo identificador coincida con idTablaDelete
			if (Integer.parseInt(corrDefCliente) < objListas.getListaDepAtCliente().size()){
				for(int i=0;i<((P06B26T00Datatype)objListas.getListaDepAtCliente().get(Integer.parseInt(corrDefCliente))).getListaRespDepAtCl().size();i++){					
					P06B28T00Datatype obj = (P06B28T00Datatype)((P06B26T00Datatype)objListas.getListaDepAtCliente().get(Integer.parseInt(corrDefCliente))).getListaRespDepAtCl().get(i);					
					if(obj.getIdentificador1()!=null && obj.getIdentificador1().equals(idTablaDelete)){						
						((P06B26T00Datatype)objListas.getListaDepAtCliente().get(Integer.parseInt(corrDefCliente))).getListaRespDepAtCl().remove(i);
						break;
					}
				}
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
			}
		}
	}
	//FIN RESPONSABLES del DEPARTAMENTO de ATENCION CLIENTE	
	
		
	
	//Obtengo los parmetros de la request y meto en la session para poder ser utilizado en la pantalla
	private void fromParamToSession(HttpServletRequest request, HttpServletResponse response) throws Exception {
		P06B20T00Datatype corredor = (P06B20T00Datatype)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"Corredor");
//		corredor = new P06B20T00Datatype();
		corredor.setExpedi((request.getParameter("Expedi")==null)?"":request.getParameter("Expedi"));
		corredor.setClase((request.getParameter("Clase")==null)?"":request.getParameter("Clase"));
		corredor.setDni((request.getParameter("DNI")==null)?"":request.getParameter("DNI"));
		corredor.setRazsoc((request.getParameter("RazSoc")==null)?"":request.getParameter("RazSoc"));
		corredor.setNombre((request.getParameter("Nombre")==null)?"":request.getParameter("Nombre"));
		corredor.setApe1((request.getParameter("Ape1")==null)?"":request.getParameter("Ape1"));
		corredor.setApe2((request.getParameter("Ape2")==null)?"":request.getParameter("Ape2"));
		corredor.setCodpro((request.getParameter("CodPro")==null)?"":request.getParameter("CodPro"));
		corredor.setCodmun((request.getParameter("CodMun")==null)?"":request.getParameter("CodMun"));
		corredor.setLocali((request.getParameter("CodLoc")==null)?"":request.getParameter("CodLoc"));
		corredor.setCodpst((request.getParameter("CodPst")==null)?"":request.getParameter("CodPst"));
		corredor.setDomici((request.getParameter("Domici")==null)?"":request.getParameter("Domici"));
		corredor.setTelefot((request.getParameter("Telefot")==null)?"":request.getParameter("Telefot"));
		corredor.setTelefom((request.getParameter("Telefom")==null)?"":request.getParameter("Telefom"));
		corredor.setTelefoc((request.getParameter("Telefoc")==null)?"":request.getParameter("Telefoc"));
		corredor.setFax1((request.getParameter("Fax1")==null)?"":request.getParameter("Fax1"));
		corredor.setFax2((request.getParameter("Fax2")==null)?"":request.getParameter("Fax2"));
		corredor.setMail((request.getParameter("Mail")==null)?"":request.getParameter("Mail"));
		corredor.setEstado((request.getParameter("Estado")==null)?"":request.getParameter("Estado"));
		corredor.setFechaBaj((request.getParameter("FechaBaj")==null)?"":request.getParameter("FechaBaj"));
		corredor.setMotivoB((request.getParameter("MotivoB")==null)?"":request.getParameter("MotivoB"));
		corredor.setCapsoc((request.getParameter("Capsoc")==null)?"":request.getParameter("Capsoc"));
		corredor.setPaticipa((request.getParameter("Paticipa")==null)?"":request.getParameter("Paticipa").replaceAll("\\.",""));
		corredor.setTrasdgs((request.getParameter("Trasdgs")==null)?"":request.getParameter("Trasdgs"));
		corredor.setWeb((request.getParameter("Web")==null)?"":request.getParameter("Web"));
		corredor.setCurso((request.getParameter("Curso")==null)?"":request.getParameter("Curso"));
		corredor.setDenCurso((request.getParameter("DenCurso")==null)?"":request.getParameter("DenCurso"));
		corredor.setAcredita((request.getParameter("Acredita")==null)?"":request.getParameter("Acredita"));
		corredor.setDAcredita((request.getParameter("DAcredita")==null)?"":request.getParameter("DAcredita"));
		corredor.setFechaAl((request.getParameter("FechaAl")==null)?"":request.getParameter("FechaAl"));
		corredor.setFechaSus((request.getParameter("FechaSus")==null)?"":request.getParameter("FechaSus"));
		corredor.setMotivoS((request.getParameter("MotivoS")==null)?"":request.getParameter("MotivoS"));
		corredor.setFecFinSu((request.getParameter("FecFinSu")==null)?"":request.getParameter("FecFinSu"));
		corredor.setDProFor((request.getParameter("DProFor")==null)?"":request.getParameter("DProFor"));
		corredor.setActIns((request.getParameter("ActIns")==null)?"":request.getParameter("ActIns"));
		int ultEjerIncorporado = 0;
		if (request.getParameter("ultEjerDECIncorporado")!=null){
			try{
				ultEjerIncorporado = Integer.parseInt(request.getParameter("ultEjerDECIncorporado"));				
			}catch(NumberFormatException nfe){
				
			}
			
		}
		int ultAtencPeticIncorporada = 0;
		if (request.getParameter("ultAtencPeticIncorporada")!=null){
			try{
				ultAtencPeticIncorporada = Integer.parseInt(request.getParameter("ultAtencPeticIncorporada"));				
			}catch(NumberFormatException nfe){
				
			}
			
		}
		corredor.setUltEjerIncorporado(ultEjerIncorporado);
		corredor.setUltAtencPeticIncorporada(ultAtencPeticIncorporada);

		
		

		
		
		
		int nEjerIncorporarDEC = -1;
		int nCorrelAtencionPeticionEnRevision = -1;
		String sObjetivo = (String)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"objetivo"+P06BConstantes.P06B_VAR_TEMP_FILTRO);
        if (sObjetivo!= null){
        	if (sObjetivo.equals(((Integer)P06BConstantes.P06B_BUSQCORR_TRAMITEPENDIENTE_INCORPORARDEC).toString())){
	        	nEjerIncorporarDEC = P06BCorredoresManager.getInstance().selectEjercicioIncorporarDEC(corredor.getExpedi());
        		
        	}else if (sObjetivo.equals(((Integer)P06BConstantes.P06B_BUSQCORR_TRAMITEPENDIENTE_INCORPORARMODTRAMITAGUNE).toString())){
        		nCorrelAtencionPeticionEnRevision = P06BCorredoresManager.getInstance().selectCorrelAtencionPeticionEnRevision(corredor.getExpedi());
        	}
        }
		
//		if (request.getParameter("estadoAceptarPropuestas")!=null){
//			corredor.setEstadoAceptarPropuestas(Byte.parseByte(request.getParameter("estadoAceptarPropuestas")));
//		}else{
//			corredor.setEstadoAceptarPropuestas(P06BConstantes.P06B_AP_ESTADO_NOREVISABLE);			
//		}
//		
		P06B20T00Datatype vo = (P06B20T00Datatype)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"Corredor");
		corredor.setDatos20Originales(vo.getDatos20Originales());
		corredor.setEjerDECAIncorporar(vo.getEjerDECAIncorporar());
		corredor.setCorrelAtencionPeticionEnRevision(nCorrelAtencionPeticionEnRevision);
		P06B60T00Datatype datosCapacidadFinanciera = vo.getDatosCapacidadFinanciera();
		if (datosCapacidadFinanciera!=null){
			datosCapacidadFinanciera.setnExpediente(vo.getExpedi());

			if (request.getParameter("CapacidadFinanciera")!=null){
				byte declaro = Byte.parseByte(request.getParameter("CapacidadFinanciera"));
				datosCapacidadFinanciera.setcFDeclaro(declaro);
				datosCapacidadFinanciera.setcFImpFondos((request.getParameter("impFondos")==null)?"":request.getParameter("impFondos"));
				datosCapacidadFinanciera.setcFImpCapacidad((request.getParameter("impCapacidad")==null)?"":request.getParameter("impCapacidad"));
				
				boolean bContrataSeguro = false;
				if (request.getParameter("contrataSeguro")!=null){
					bContrataSeguro = true;
				}
				datosCapacidadFinanciera.setcFContrataSeguro(bContrataSeguro);
				datosCapacidadFinanciera.setcFTextoSeguro(request.getParameter("textoSeguro"));
				
				boolean bContrataAval = false;
				if (request.getParameter("contrataAval")!=null){
					bContrataAval = true;
				}
				datosCapacidadFinanciera.setcFContrataAval(bContrataAval);
				datosCapacidadFinanciera.setcFTextoAval(request.getParameter("textoAval"));			
			}			
		}
		corredor.setDatosCapacidadFinanciera(vo.getDatosCapacidadFinanciera());
		
		if (request.getParameter("DefensaAtencionCliente")!=null){
			if (!request.getParameter("DefensaAtencionCliente").equals(corredor.getTipoAtencionCliente())){
				corredor.setTipoAtencionCliente(request.getParameter("DefensaAtencionCliente"));			
				//Ahora recupero los defensores de cliente relacionados con el corredor
				String sExpedienteEnAtencionDefensaCliente = "";
				if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_CUENTACONSERVICIO)){
					sExpedienteEnAtencionDefensaCliente = corredor.getExpedi();
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCV)){
					sExpedienteEnAtencionDefensaCliente = P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCVEXPEDIENTEFICTICIO;					
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCG)){
					sExpedienteEnAtencionDefensaCliente = P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCGEXPEDIENTEFICTICIO;										
				}
				//TODO Adrian Informar correctamente bCargaIncorporarModTramitagune
				P06BCorredorListasAux objListas = null;
				if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
					objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
				}else{
					objListas = new P06BCorredorListasAux();
				}
				if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_CUENTACONSERVICIO)){
					if (nCorrelAtencionPeticionEnRevision!=-1){
						objListas.setListaDefCliente(P06BCorredoresManager.getInstance().selectDefClienteIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision,corredor.getTipoAtencionCliente(),sExpedienteEnAtencionDefensaCliente));
					}else{
						objListas.setListaDefCliente(P06BCorredoresManager.getInstance().selectDefCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
					}
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCV)){
					objListas.setListaDefCliente(P06BCorredoresManager.getInstance().selectDefCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCG)){
					objListas.setListaDefCliente(P06BCorredoresManager.getInstance().selectDefCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
				}

				if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_CUENTACONSERVICIO)){
					if (nCorrelAtencionPeticionEnRevision!=-1){
						objListas.setListaDepAtCliente(P06BCorredoresManager.getInstance().selectDepAtClienteIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision,corredor.getTipoAtencionCliente(),sExpedienteEnAtencionDefensaCliente));
					}else{
						objListas.setListaDepAtCliente(P06BCorredoresManager.getInstance().selectDepAtCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
					}
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCV)){
					objListas.setListaDepAtCliente(P06BCorredoresManager.getInstance().selectDepAtCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCG)){
					objListas.setListaDepAtCliente(P06BCorredoresManager.getInstance().selectDepAtCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
				}
//				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
			}
		}
		
		//As actualizamos los datos de la pantalla
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"Corredor",corredor);
	}
	
	//Obtengo las provincias, municipios, localidades y CP's
	private void obtenerFCAs(HttpServletRequest request, HttpServletResponse response) throws Exception {
		ArrayList listaProvincias = P06BGeneralManager.getInstance().obtenerProvincias(this.getIdioma(request,response));
		request.setAttribute("listaProvincias",listaProvincias);
		if(request.getParameter("CodPro")!=null
				&& !request.getParameter("CodPro").equals("")){
			ArrayList listaMunicipios = P06BGeneralManager.getInstance().obtenerMunicipios(Integer.parseInt(request.getParameter("CodPro")));
			request.setAttribute("listaMunicipios",listaMunicipios);
			if(request.getParameter("CodMun")!=null
					&& !request.getParameter("CodMun").equals("")){
				ArrayList listaLocalidades = P06BGeneralManager.getInstance().obtenerLocalidades(
						Integer.parseInt(request.getParameter("CodPro")),Integer.parseInt(request.getParameter("CodMun")));
				request.setAttribute("listaLocalidades",listaLocalidades);
				if(request.getParameter("CodLoc")!=null
						&& !request.getParameter("CodLoc").equals("")){
					ArrayList listaCP = P06BGeneralManager.getInstance().obtenerCodPostales(
							Integer.parseInt(request.getParameter("CodPro")),
							Integer.parseInt(request.getParameter("CodMun")),
							Integer.parseInt(request.getParameter("CodLoc")));
					request.setAttribute("listaCP",listaCP);
				}
			}
		}
	}
	
	//Obtengo las provincias, municipios, localidades y CP's
	//Ojo, en este caso obtengo del atributo de la request 
	private void obtenerFCAs2(HttpServletRequest request, HttpServletResponse response) throws Exception {
		P06B20T00Datatype vo = (P06B20T00Datatype)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"Corredor");
		ArrayList listaProvincias = P06BGeneralManager.getInstance().obtenerProvincias(this.getIdioma(request,response));
		request.setAttribute("listaProvincias",listaProvincias);
		if(!vo.getCodpro().equals("")){
			ArrayList listaMunicipios = P06BGeneralManager.getInstance().obtenerMunicipios(Integer.parseInt(vo.getCodpro()));
			request.setAttribute("listaMunicipios",listaMunicipios);
			if(!vo.getCodmun().equals("")){
				ArrayList listaLocalidades = P06BGeneralManager.getInstance().obtenerLocalidades(
						Integer.parseInt(vo.getCodpro()),Integer.parseInt(vo.getCodmun()));
				request.setAttribute("listaLocalidades",listaLocalidades);
				if(!vo.getLocali().equals("")){
					ArrayList listaCP = P06BGeneralManager.getInstance().obtenerCodPostales(
							Integer.parseInt(vo.getCodpro()),
							Integer.parseInt(vo.getCodmun()),
							Integer.parseInt(vo.getLocali()));
					request.setAttribute("listaCP",listaCP);
				}
			}
		}
	}
	
	//Obtengo el corredor de la B.D. y lo meto en la request
	private boolean obtener(HttpServletRequest request, HttpServletResponse response) throws Exception {
		boolean retorno = true;
		P06BCorredorListasAux objListas = new P06BCorredorListasAux();
		if(request.getParameter("Expedi")!=null
				&& !request.getParameter("Expedi").trim().equals("")){
			P06B20T00Datatype corredor = P06BCorredoresManager.getInstance().selectCorredor(request.getParameter("Expedi"));
	        P06B64T00Datatype datosUltimaAtencionRevisada = null;
	        datosUltimaAtencionRevisada = P06BCorredoresManager.getInstance().selectDatosAtencPeticTramitagune(corredor.getUltAtencPeticIncorporada());
	        corredor.setDatosUltimaAtencionRevisada(datosUltimaAtencionRevisada);
	        P06B64T00Datatype datosAtencionPeticionEnRevision = null;
			//Mostrar tambien datos Capacidad Financiera
			P06B60T00Datatype capacidadFinanciera = null;
			if (P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA.equals(corredor.getClase()) || P06BConstantes.P06B_CORREDORES_TIPOPER_JURIDICA.equals(corredor.getClase()) ||
					P06BConstantes.P06B_AGENTEVINCULADO_FISICA.equals(corredor.getClase()) || P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA.equals(corredor.getClase())){
				capacidadFinanciera = P06BCorredoresManager.getInstance().selectCapacidadFinanciera(request.getParameter("Expedi"));				
				corredor.setDatosCapacidadFinanciera(capacidadFinanciera);
			}else{
				corredor.setDatosCapacidadFinanciera(new P06B60T00Datatype());
			}
			if(corredor==null){
				 corredor = new P06B20T00Datatype();
				 corredor.setExpedi(request.getParameter("Expedi"));
				 retorno = false;
			}else{
				boolean bCargaIncorporarDEC = false;
				int nEjerIncorporarDEC = -1;
				boolean bCargaIncorporarModTramitagune = false;
				int nCorrelAtencionPeticionEnRevision = -1;
//				corredor.setEstadoAceptarPropuestas(P06BConstantes.P06B_AP_ESTADO_NOREVISABLE);
				String sObjetivo = (String)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"objetivo"+P06BConstantes.P06B_VAR_TEMP_FILTRO);
		        if (sObjetivo!= null){
		        	if (sObjetivo.equals(((Integer)P06BConstantes.P06B_BUSQCORR_TRAMITEPENDIENTE_INCORPORARDEC).toString())){
			        	nEjerIncorporarDEC = P06BCorredoresManager.getInstance().selectEjercicioIncorporarDEC(corredor.getExpedi());
				        corredor = P06BCorredoresManager.getInstance().selectCorredorIncorporacion(request.getParameter("Expedi"),nEjerIncorporarDEC);		        		
						if (P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA.equals(corredor.getClase()) || P06BConstantes.P06B_CORREDORES_TIPOPER_JURIDICA.equals(corredor.getClase()) ||
								P06BConstantes.P06B_AGENTEVINCULADO_FISICA.equals(corredor.getClase()) || P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA.equals(corredor.getClase())){
							P06B60T00Datatype capacidadFinancieraT = P06BCorredoresManager.getInstance().selectIncorporacion(request.getParameter("Expedi"), nEjerIncorporarDEC, capacidadFinanciera);
							capacidadFinancieraT.setDatos60Originales(capacidadFinanciera);									
							corredor.setDatosCapacidadFinanciera(capacidadFinancieraT);
								
						}
						
//						corredor.setEstadoAceptarPropuestas(P06BConstantes.P06B_AP_ESTADO_PORREVISAR);
			        	corredor.setEjerDECAIncorporar(nEjerIncorporarDEC);
			        	bCargaIncorporarDEC = true;
		        		
		        	}else if (sObjetivo.equals(((Integer)P06BConstantes.P06B_BUSQCORR_TRAMITEPENDIENTE_INCORPORARMODTRAMITAGUNE).toString())){
		        		nCorrelAtencionPeticionEnRevision = P06BCorredoresManager.getInstance().selectCorrelAtencionPeticionEnRevision(corredor.getExpedi());
				        datosAtencionPeticionEnRevision = P06BCorredoresManager.getInstance().selectDatosAtencPeticTramitagune(nCorrelAtencionPeticionEnRevision);
			        	bCargaIncorporarModTramitagune = true;
		        	}
		        }else{
		        	P06B64T00Datatype datosAtencionPeticionEnRevisionAux = null;
		        	datosAtencionPeticionEnRevisionAux = (P06B64T00Datatype)request.getSession().getAttribute("AtencionPeticionEnRevision");  
	        		if (datosAtencionPeticionEnRevisionAux != null){
		        		if (datosAtencionPeticionEnRevisionAux.getProcedimiento().equals(P06BParametros.get("idProcModRegMedSeg"))){
		        			if (datosAtencionPeticionEnRevisionAux.getEstado()==P06BConstantes.P06B_AP_ESTADO_PORREVISAR){
				        		nCorrelAtencionPeticionEnRevision = datosAtencionPeticionEnRevisionAux.getCorrelativo();
						        datosAtencionPeticionEnRevision = datosAtencionPeticionEnRevisionAux;
					        	bCargaIncorporarModTramitagune = true;		        				
		        			}
		        		}	        			
	        		}
	        	}
		        
	        	if (bCargaIncorporarModTramitagune){
			        corredor = P06BCorredoresManager.getInstance().selectCorredorCorrelAtencionPeticionEnRevision(request.getParameter("Expedi"), datosAtencionPeticionEnRevision);
			        corredor.setDatosAtencionPeticionEnRevision(datosAtencionPeticionEnRevision);
					if (P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA.equals(corredor.getClase()) || P06BConstantes.P06B_CORREDORES_TIPOPER_JURIDICA.equals(corredor.getClase()) ||
							P06BConstantes.P06B_AGENTEVINCULADO_FISICA.equals(corredor.getClase()) || P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA.equals(corredor.getClase())){
						if (datosAtencionPeticionEnRevision.isbActualizarCapacidadFinanciera()){
							P06B60T00Datatype capacidadFinancieraT = P06BCorredoresManager.getInstance().selectCapacidadFinancieraCorrelAtencionPeticionEnRevision2(request.getParameter("Expedi"), datosAtencionPeticionEnRevision.getCorrelativo(), capacidadFinanciera);
							capacidadFinancieraT.setDatos60Originales(capacidadFinanciera);									
							corredor.setDatosCapacidadFinanciera(capacidadFinancieraT);
						}
							
					}		        		
	        	}
	        	
	        	corredor.setCorrelAtencionPeticionEnRevision(nCorrelAtencionPeticionEnRevision);
				//Ojo con los Double, Cambio los puntos por comas
//				corredor.setCapsoc(corredor.getCapsoc().replaceAll("\\.",","));

				//Cambio las fecha en caso de que sea euskera el idioma
				String idioma = this.getIdioma(request, response);
				if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
					corredor.setFechaBaj(P06BFecha.fechaEuFromFecha(corredor.getFechaBaj()));
					corredor.setFechaAl(P06BFecha.fechaEuFromFecha(corredor.getFechaAl()));
					corredor.setFechaSus(P06BFecha.fechaEuFromFecha(corredor.getFechaSus()));
					corredor.setFecFinSu(P06BFecha.fechaEuFromFecha(corredor.getFecFinSu()));
					corredor.setTrasdgs(P06BFecha.fechaEuFromFecha(corredor.getTrasdgs()));
				}
				
				//---------- LAS LISTAS SE OBTIENEN POR EXPEDIENTE Y TIPO ----------
				
				//Ahora recupero los socios directos relacionados con el corredor
		        if (bCargaIncorporarDEC){
					objListas.setListaSocios(P06BCorredoresManager.getInstance().selectSociosIncorporacionDEC(corredor.getExpedi(),nEjerIncorporarDEC));
		        }else if (bCargaIncorporarModTramitagune){
					objListas.setListaSocios(P06BCorredoresManager.getInstance().selectSociosIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision));
		        }else{
					objListas.setListaSocios(P06BCorredoresManager.getInstance().selectSocios(corredor.getExpedi()));
		        }

		        //Ahora recupero los socios INdirectos relacionados con el corredor
				objListas.setListaSociosIndirec(P06BCorredoresManager.getInstance().selectSociosIndirec(corredor.getExpedi()));
				//Ahora recupero los auxiliares externos relacionados con el corredor
				objListas.setListaAuxExternos(P06BCorredoresManager.getInstance().selectAuxExternos(corredor.getExpedi()));
					
		        if (bCargaIncorporarDEC){
					//Ahora recupero los administradores relacionados con el corredor
					objListas.setListaAdministradores(P06BCorredoresManager.getInstance().selectAdministradoresIncorporacionDEC(corredor.getExpedi(),nEjerIncorporarDEC));
					//Ahora recupero los rganos de direccin relacionados con el corredor
					objListas.setListaOrganos(P06BCorredoresManager.getInstance().selectOrganosDirIncorporacionDEC(corredor.getExpedi(),nEjerIncorporarDEC));
					//Ahora recupero la direccin tcnica relacionados con el corredor
					objListas.setListaDirecTec(P06BCorredoresManager.getInstance().selectDirecTecIncorporacionDEC(corredor.getExpedi(),nEjerIncorporarDEC));
					//Ahora recupero las otras personas de direccion, que no son organos ni tecnica, relacionados con el corredor
					objListas.setListaOtrosDirec(P06BCorredoresManager.getInstance().selectOtrosDirecIncorporacionDEC(corredor.getExpedi(),nEjerIncorporarDEC));
		        }else if (bCargaIncorporarModTramitagune){
					//Ahora recupero los administradores relacionados con el corredor
					objListas.setListaAdministradores(P06BCorredoresManager.getInstance().selectAdministradoresIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision));
					//Ahora recupero los rganos de direccin relacionados con el corredor
					objListas.setListaOrganos(P06BCorredoresManager.getInstance().selectOrganosDirIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision));
					//Ahora recupero la direccin tcnica relacionados con el corredor
//					objListas.setListaDirecTec(P06BCorredoresManager.getInstance().selectDirecTecIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision));
					objListas.setListaDirecTec(P06BCorredoresManager.getInstance().selectDirecTec(corredor.getExpedi()));
					//Ahora recupero las otras personas de direccion, que no son organos ni tecnica, relacionados con el corredor
//					objListas.setListaOtrosDirec(P06BCorredoresManager.getInstance().selectOtrosDirecIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision));
					objListas.setListaOtrosDirec(P06BCorredoresManager.getInstance().selectOtrosDirec(corredor.getExpedi()));
		        }else{
					//Ahora recupero los administradores relacionados con el corredor
					objListas.setListaAdministradores(P06BCorredoresManager.getInstance().selectAdministradores(corredor.getExpedi()));
					//Ahora recupero los rganos de direccin relacionados con el corredor
					objListas.setListaOrganos(P06BCorredoresManager.getInstance().selectOrganosDir(corredor.getExpedi()));
					//Ahora recupero la direccin tcnica relacionados con el corredor
					objListas.setListaDirecTec(P06BCorredoresManager.getInstance().selectDirecTec(corredor.getExpedi()));
					//Ahora recupero las otras personas de direccion, que no son organos ni tecnica, relacionados con el corredor
					objListas.setListaOtrosDirec(P06BCorredoresManager.getInstance().selectOtrosDirec(corredor.getExpedi()));
		        }

				
				//Ahora recupero las sucursales relacionadas con el corredor
				objListas.setListaSucursales(P06BCorredoresManager.getInstance().selectSucursales(corredor.getExpedi()));
				
				//Ahora recupero los defensores de cliente relacionados con el corredor
				String sExpedienteEnAtencionDefensaCliente = "";
				if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_CUENTACONSERVICIO)){
					sExpedienteEnAtencionDefensaCliente = corredor.getExpedi();
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCV)){
					sExpedienteEnAtencionDefensaCliente = P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCVEXPEDIENTEFICTICIO;					
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCG)){
					sExpedienteEnAtencionDefensaCliente = P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCGEXPEDIENTEFICTICIO;										
				}
//				if (bCargaIncorporarModTramitagune){
//					objListas.setListaDefCliente(P06BCorredoresManager.getInstance().selectDefClienteIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision,corredor.getTipoAtencionCliente(),sExpedienteEnAtencionDefensaCliente));
//				}else{
//					objListas.setListaDefCliente(P06BCorredoresManager.getInstance().selectDefCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
//				}
				if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_CUENTACONSERVICIO)){
					if (nCorrelAtencionPeticionEnRevision!=-1){
						objListas.setListaDefCliente(P06BCorredoresManager.getInstance().selectDefClienteIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision,corredor.getTipoAtencionCliente(),sExpedienteEnAtencionDefensaCliente));
					}else{
						objListas.setListaDefCliente(P06BCorredoresManager.getInstance().selectDefCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
					}
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCV)){
					objListas.setListaDefCliente(P06BCorredoresManager.getInstance().selectDefCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCG)){
					objListas.setListaDefCliente(P06BCorredoresManager.getInstance().selectDefCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
				}
				//Ahora recupero los departamentos de atencin al cliente relacionados con el corredor
//				if (bCargaIncorporarModTramitagune){
//					objListas.setListaDepAtCliente(P06BCorredoresManager.getInstance().selectDepAtClienteIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision,corredor.getTipoAtencionCliente(),sExpedienteEnAtencionDefensaCliente));
//				}else{
//					objListas.setListaDepAtCliente(P06BCorredoresManager.getInstance().selectDepAtCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
//				}
				if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_CUENTACONSERVICIO)){
					if (nCorrelAtencionPeticionEnRevision!=-1){
						objListas.setListaDepAtCliente(P06BCorredoresManager.getInstance().selectDepAtClienteIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision,corredor.getTipoAtencionCliente(),sExpedienteEnAtencionDefensaCliente));
					}else{
						objListas.setListaDepAtCliente(P06BCorredoresManager.getInstance().selectDepAtCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
					}
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCV)){
					objListas.setListaDepAtCliente(P06BCorredoresManager.getInstance().selectDepAtCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
				}else if (corredor.getTipoAtencionCliente().equals(P06BConstantes.P06B_AC_ADHERIDOALCOLEGIOCG)){
					objListas.setListaDepAtCliente(P06BCorredoresManager.getInstance().selectDepAtCliente(sExpedienteEnAtencionDefensaCliente,corredor.getTipoAtencionCliente()));
				}
				//Ahora recupero los socios directos relacionados con el corredor
		        if (bCargaIncorporarDEC){
					objListas.setListaEVs(P06BCorredoresManager.getInstance().selectEVsIncorporacionDEC(corredor.getExpedi(),nEjerIncorporarDEC));
		        }else if (bCargaIncorporarModTramitagune){
					objListas.setListaEVs(P06BCorredoresManager.getInstance().selectEVsIncorporacionModTramitagune(corredor.getExpedi(),nCorrelAtencionPeticionEnRevision));
		        }else{
					objListas.setListaEVs(P06BCorredoresManager.getInstance().selectEVs(corredor.getExpedi()));
		        }
				
				//Socios
				P06B22T00Datatype socio = null;
				for(int i=0;i<objListas.getListaSocios().size();i++){
					socio = (P06B22T00Datatype)objListas.getListaSocios().get(i);
					
					//Ojo con los Double, Cambio los puntos por comas
//					socio.setParticipa(socio.getParticipa().replaceAll("\\.",","));
					
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						//Modifico las fechas de alta y de baja
						socio.setFecAlta(P06BFecha.fechaEuFromFecha(socio.getFecAlta()));
						socio.setFecBaja(P06BFecha.fechaEuFromFecha(socio.getFecBaja()));
					}
				}
				
				//Socios Indirectos
				socio = null;
				for(int i=0;i<objListas.getListaSociosIndirec().size();i++){
					socio = (P06B22T00Datatype)objListas.getListaSociosIndirec().get(i);
					
					//Ojo con los Double, Cambio los puntos por comas
//					socio.setParticipa(socio.getParticipa().replaceAll("\\.",","));
					
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						//Modifico las fechas de alta y de baja
						socio.setFecAlta(P06BFecha.fechaEuFromFecha(socio.getFecAlta()));
						socio.setFecBaja(P06BFecha.fechaEuFromFecha(socio.getFecBaja()));
					}
				}
				
				//Auxiliares Externos
				socio = null;
				for(int i=0;i<objListas.getListaAuxExternos().size();i++){
					socio = (P06B22T00Datatype)objListas.getListaAuxExternos().get(i);
					
					//Ojo con los Double, Cambio los puntos por comas
//					socio.setParticipa(socio.getParticipa().replaceAll("\\.",","));
					
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						//Modifico las fechas de alta y de baja
						socio.setFecAlta(P06BFecha.fechaEuFromFecha(socio.getFecAlta()));
						socio.setFecBaja(P06BFecha.fechaEuFromFecha(socio.getFecBaja()));
					}
				}
				
				//rganos
				P06B24T00Datatype organo = null;
				for(int i=0;i<objListas.getListaOrganos().size();i++){
					organo = (P06B24T00Datatype)objListas.getListaOrganos().get(i);
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						//Modifico las fechas
						organo.setFechNom(P06BFecha.fechaEuFromFecha(organo.getFechNom()));
						organo.setFecSus(P06BFecha.fechaEuFromFecha(organo.getFecSus()));
						organo.setFecLeSus(P06BFecha.fechaEuFromFecha(organo.getFecLeSus()));
						organo.setFecRev(P06BFecha.fechaEuFromFecha(organo.getFecRev()));
						organo.setFecInha(P06BFecha.fechaEuFromFecha(organo.getFecInha()));
						organo.setFecCese(P06BFecha.fechaEuFromFecha(organo.getFecCese()));
					}
				}
				
				//Direccin Tcnica
				organo = null;
				for(int i=0;i<objListas.getListaDirecTec().size();i++){
					organo = (P06B24T00Datatype)objListas.getListaDirecTec().get(i);
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						//Modifico las fechas
						organo.setFechNom(P06BFecha.fechaEuFromFecha(organo.getFechNom()));
						organo.setFecSus(P06BFecha.fechaEuFromFecha(organo.getFecSus()));
						organo.setFecLeSus(P06BFecha.fechaEuFromFecha(organo.getFecLeSus()));
						organo.setFecRev(P06BFecha.fechaEuFromFecha(organo.getFecRev()));
						organo.setFecInha(P06BFecha.fechaEuFromFecha(organo.getFecInha()));
						organo.setFecCese(P06BFecha.fechaEuFromFecha(organo.getFecCese()));
					}
				}
				
				//Otros Direccin
				organo = null;
				for(int i=0;i<objListas.getListaOtrosDirec().size();i++){
					organo = (P06B24T00Datatype)objListas.getListaOtrosDirec().get(i);
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						//Modifico las fechas
						organo.setFechNom(P06BFecha.fechaEuFromFecha(organo.getFechNom()));
						organo.setFecSus(P06BFecha.fechaEuFromFecha(organo.getFecSus()));
						organo.setFecLeSus(P06BFecha.fechaEuFromFecha(organo.getFecLeSus()));
						organo.setFecRev(P06BFecha.fechaEuFromFecha(organo.getFecRev()));
						organo.setFecInha(P06BFecha.fechaEuFromFecha(organo.getFecInha()));
						organo.setFecCese(P06BFecha.fechaEuFromFecha(organo.getFecCese()));
					}
				}
				
				//Administradores
				organo = null;
				for(int i=0;i<objListas.getListaAdministradores().size();i++){
					organo = (P06B24T00Datatype)objListas.getListaAdministradores().get(i);
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						//Modifico las fechas
						organo.setFechNom(P06BFecha.fechaEuFromFecha(organo.getFechNom()));
						organo.setFecSus(P06BFecha.fechaEuFromFecha(organo.getFecSus()));
						organo.setFecLeSus(P06BFecha.fechaEuFromFecha(organo.getFecLeSus()));
						organo.setFecRev(P06BFecha.fechaEuFromFecha(organo.getFecRev()));
						organo.setFecInha(P06BFecha.fechaEuFromFecha(organo.getFecInha()));
						organo.setFecCese(P06BFecha.fechaEuFromFecha(organo.getFecCese()));
					}
				}
				
			}	 
			request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"Corredor",corredor);
			request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux",objListas);
		}else{
			retorno = false;
		}
		return retorno;
	}
	
	
	//Validamos campos del formulario
	private boolean validate(HttpServletRequest request, HttpServletResponse response) throws Exception {
		//INICIO PANTALLA PRINCIPAL
		ArrayList errors = new ArrayList();
		boolean resultado = true;
		String idioma = this.getIdioma(request,response);
		//Con la informacin obtenida realizo las validaciones
		P06BResources res = (P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS); 
		
		//Campo Clase -> Obligatorio
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.tipoPersona"),request.getParameter("Clase"),idioma);
		
		//Campo NIF/CIF -> Obligatorio
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.nifCif"),request.getParameter("DNI"),idioma);

		//Campo Cdigo Postal -> Entero
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.codigoPostal"),request.getParameter("CodPst"),idioma);
		
		//Campos de Telfono y Fax
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.tfno1"),request.getParameter("Telefot"),idioma);
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.tfno2"),request.getParameter("Telefom"),idioma);
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.tfno3"),request.getParameter("Telefoc"),idioma);
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.fax1"),request.getParameter("Fax1"),idioma);
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.fax2"),request.getParameter("Fax2"),idioma);
		
		//Campo de ultimo ejercicio introducido DEC
//		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.EJERCICIO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.ultEjerDECIncorporado"),request.getParameter("ultEjerDECIncorporado"),idioma);
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.ultEjerDECIncorporado"),request.getParameter("ultEjerDECIncorporado"),idioma);

		//Campo de mail
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.MAIL,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.mail"),request.getParameter("Mail"),idioma);
		
		//Fecha alta -> Obligatoria y Fecha valida
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.fAlta"),request.getParameter("FechaAl"),idioma);
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.fAlta"),request.getParameter("FechaAl"),idioma);
		
		//Estado ->Obligatorio
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.estado"),request.getParameter("Estado"),idioma);
		
		//Campos Capital Social -> Decimal
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.DECIMAL,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.capsoc"),request.getParameter("Capsoc"),idioma,99999999999.99);	
		
		//Campo N Participaciones-> Entero
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.paticipa"),request.getParameter("Paticipa"),idioma);
		
		//Si el estado es Baja, obligar a introducir la fecha de baja
		if (P06BConstantes.P06B_CORREDORES_ESTADO_BAJA.equals(request.getParameter("Estado")) || P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_BAJA.equals(request.getParameter("Estado"))){
			errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.fechaBaja"),request.getParameter("FechaBaj"),idioma);
		}
		//Campo Fecha Baja -> Fecha Vlida
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.fechaBaja"),request.getParameter("FechaBaj"),idioma);
		
		//Si el estado es Suspensin, obligar a introducir la fecha de suspensin
		if (P06BConstantes.P06B_CORREDORES_ESTADO_SUSPENSION.equals(request.getParameter("Estado"))){
			errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.fhSuspen"),request.getParameter("FechaSus"),idioma);
		}
		//Campos Fecha Suspension y Fecha Fin Suspension -> Fecha valida
		int auxNumErr = errors.size();
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.fhSuspen"),request.getParameter("FechaSus"),idioma);
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.fhFinSus"),request.getParameter("FecFinSu"),idioma);
		if(auxNumErr==errors.size()){
			//Significa que fecha suspendion y fecha fin suspension son correctos
			errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPFECHA,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.fhSuspen"), res.get("pantallas.literal.fhFinSus"),request.getParameter("FechaSus"), request.getParameter("FecFinSu"),idioma);
		}
		
		//Campo Fecha Traslado DGS -> Fecha Vlida
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.trasdgs"),request.getParameter("Trasdgs"),idioma);
		
		//Areas de texto - Comprobar longitud
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.cursoFormacion"),request.getParameter("DenCurso"),idioma,250);
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.acredHonorabilidad"),request.getParameter("DAcredita"),idioma,250);
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.progrFormacion"),request.getParameter("DProFor"),idioma,100);
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.mediador") + " - " + res.get("pantallas.literal.actosInscrib"),request.getParameter("ActIns"),idioma,250);
		
		
		P06BCorredorListasAux objListas = null;
		if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
			objListas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
		}else{
			objListas = new P06BCorredorListasAux();
		}
		//FIN PANTALLA PRINCIPAL
		
		
		//PESTAA 2 - SOCIOS
		int numSocios = objListas.getListaSocios().size();		
		int z=0,numErrors = 0;;
		P06B22T00Datatype socio = null;
		boolean valida1 = true, valida2 = true, valida3 = true;
		
		for(z=0;z<numSocios;z++){
			socio = (P06B22T00Datatype)objListas.getListaSocios().get(z);
			numErrors = errors.size();
			if(valida1){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.accionisDirec") + " - " + res.get("pantallas.literal.fAlta"),socio.getFecAlta(),idioma);
				if(numErrors<errors.size())
					valida1=false;
			}
			numErrors = errors.size();
			if(valida2){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.accionisDirec") + " - " + res.get("pantallas.literal.fechaBaja"),socio.getFecBaja(),idioma);
				if(numErrors<errors.size())
					valida2=false;
			}
			numErrors = errors.size();
			if(valida3){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.DECIMAL,res.get("pantallas.literal.accionisDirec") + " - " + res.get("pantallas.literal.participacion"),socio.getParticipa(),idioma,100.00);
				if(numErrors<errors.size())
					valida3=false;
			}
		}
		
		//Valida que si se ha introducido algun dato en alguna fila, se obligue a introducir el Identificador(CIF/NIF).		
		z = 0;
		socio = null;
		valida1 = true;
		while (valida1 && z<numSocios){
			socio = (P06B22T00Datatype)objListas.getListaSocios().get(z);
			if (
				(socio.getIdentificador()==null || socio.getIdentificador().trim().equals("")) 
				&& (
                    (socio.getRazSoc()!=null && !socio.getRazSoc().trim().equals(""))
					|| (socio.getNombre()!=null && !socio.getNombre().trim().equals(""))
					|| (socio.getApe1()!=null && !socio.getApe1().trim().equals(""))
					|| (socio.getApe2()!=null && !socio.getApe2().trim().equals(""))
					|| (socio.getDomici()!=null && !socio.getDomici().trim().equals(""))
					|| (socio.getCodmun()!=null && !socio.getCodmun().trim().equals(""))
					|| (socio.getLocali()!=null && !socio.getLocali().trim().equals(""))
					|| (socio.getCodpro()!=null && !socio.getCodpro().trim().equals(""))
					|| (socio.getCodpst()!=null && !socio.getCodpst().trim().equals(""))
					|| (socio.getFecAlta()!=null && !socio.getFecAlta().trim().equals(""))
					|| (socio.getFecBaja()!=null && !socio.getFecBaja().trim().equals(""))
					|| (socio.getParticipa()!=null && !socio.getParticipa().trim().equals(""))
					)
				){
				errors=this.insertaError(errors, res.get("pantallas.literal.accionisDirec") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0015);
				valida1=false;
			}
			z++;
		}
		
		//Valida que el campo Identificador(CIF/NIF) no est repetido
		z = 0;
		socio = null;
		valida1 = true;
		int i = 0;
		P06B22T00Datatype socio2 = null;
		while (valida1 && z<numSocios){
			i = 0;
			socio = (P06B22T00Datatype)objListas.getListaSocios().get(z);
			while (valida1 && i<numSocios){
				if (i!=z){
					socio2 = (P06B22T00Datatype)objListas.getListaSocios().get(i);
					if (socio.getIdentificador()!=null && !socio.getIdentificador().trim().equals("") && socio2.getIdentificador()!=null && !socio2.getIdentificador().trim().equals("") && socio.getIdentificador().trim().equals(socio2.getIdentificador().trim())){
						errors=this.insertaError(errors, res.get("pantallas.literal.accionisDirec") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0016);
						valida1=false;
					}
				}				
				i++;
			}
			z++;
		}
		//FIN PESTAA 2 - SOCIOS
		
		
		//PESTAA - SOCIOS INDIRECTOS
		int numSociosIndirec = objListas.getListaSociosIndirec().size();
		z=0; numErrors = 0;
		socio = null;
		valida1 = true; valida2 = true; valida3 = true;
		for(z=0;z<numSociosIndirec;z++){
			socio = (P06B22T00Datatype)objListas.getListaSociosIndirec().get(z);
			
			//La fecha de alta --> Fecha vlida
			numErrors = errors.size();
			if(valida1){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.accionisIndirec") + " - " + res.get("pantallas.literal.fAlta"),socio.getFecAlta(),idioma);
				if(numErrors<errors.size())
					valida1=false;
			}
			
			//La fecha de baja --> Fecha vlida
			numErrors = errors.size();
			if(valida2){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.accionisIndirec") + " - " + res.get("pantallas.literal.fechaBaja"),socio.getFecBaja(),idioma);
				if(numErrors<errors.size())
					valida2=false;
			}
			
			//La participacion --> Decimal no superiror a 100.0
			numErrors = errors.size();
			if(valida3){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.DECIMAL,res.get("pantallas.literal.accionisIndirec") + " - " + res.get("pantallas.literal.participacion"),socio.getParticipa(),idioma,100.00);
				if(numErrors<errors.size())
					valida3=false;
			}
		}
		
		//Valida que si se ha introducido algun dato en alguna fila, se obligue a introducir el Identificador(CIF/NIF).		
		z = 0;
		socio = null;
		valida1 = true;
		while (valida1 && z<numSociosIndirec){
			socio = (P06B22T00Datatype)objListas.getListaSociosIndirec().get(z);
			if (
				(socio.getIdentificador()==null || socio.getIdentificador().trim().equals("")) 
				&& (
                    (socio.getRazSoc()!=null && !socio.getRazSoc().trim().equals(""))
					|| (socio.getNombre()!=null && !socio.getNombre().trim().equals(""))
					|| (socio.getApe1()!=null && !socio.getApe1().trim().equals(""))
					|| (socio.getApe2()!=null && !socio.getApe2().trim().equals(""))
					|| (socio.getDomici()!=null && !socio.getDomici().trim().equals(""))
					|| (socio.getCodmun()!=null && !socio.getCodmun().trim().equals(""))
					|| (socio.getLocali()!=null && !socio.getLocali().trim().equals(""))
					|| (socio.getCodpro()!=null && !socio.getCodpro().trim().equals(""))
					|| (socio.getCodpst()!=null && !socio.getCodpst().trim().equals(""))
					|| (socio.getFecAlta()!=null && !socio.getFecAlta().trim().equals(""))
					|| (socio.getFecBaja()!=null && !socio.getFecBaja().trim().equals(""))
					|| (socio.getParticipa()!=null && !socio.getParticipa().trim().equals(""))
					)
				){
				errors=this.insertaError(errors, res.get("pantallas.literal.accionisIndirec") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0015);
				valida1=false;
			}
			z++;
		}

		//Valida que el campo Identificador(CIF/NIF) no est repetido
		z = 0;
		socio = null;
		valida1 = true;
		i = 0;
		socio2 = null;
		while (valida1 && z<numSociosIndirec){
			i = 0;
			socio = (P06B22T00Datatype)objListas.getListaSociosIndirec().get(z);
			while (valida1 && i<numSociosIndirec){
				if (i!=z){
					socio2 = (P06B22T00Datatype)objListas.getListaSociosIndirec().get(i);
					if (socio.getIdentificador()!=null && !socio.getIdentificador().trim().equals("") && socio2.getIdentificador()!=null && !socio2.getIdentificador().trim().equals("") && socio.getIdentificador().trim().equals(socio2.getIdentificador().trim())){
						errors=this.insertaError(errors, res.get("pantallas.literal.accionisIndirec") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0016);
						valida1=false;
					}
				}				
				i++;
			}
			z++;
		}
		//FIN PESTAA - SOCIOS INDIRECTOS
		
		
		//PESTAA - AUXILIARES EXTERNOS
		int numAuxExternos = objListas.getListaAuxExternos().size();
		z = 0; numErrors = 0;
		socio = null;
		valida1 = true; valida2 = true; valida3 = true;
		for(z=0;z<numAuxExternos;z++){
			socio = (P06B22T00Datatype)objListas.getListaAuxExternos().get(z);
			
			//La fecha de alta --> Fecha vlida
			numErrors = errors.size();
			if(valida1){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.auxilExterno") + " - " + res.get("pantallas.literal.fAlta"),socio.getFecAlta(),idioma);
				if(numErrors<errors.size())
					valida1=false;
			}
			
			//La fecha de baja --> Fecha vlida
			numErrors = errors.size();
			if(valida2){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.auxilExterno") + " - " + res.get("pantallas.literal.fechaBaja"),socio.getFecBaja(),idioma);
				if(numErrors<errors.size())
					valida2=false;
			}
			
			//La participacion --> Decimal no superiror a 100.0
			numErrors = errors.size();
			if(valida3){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.DECIMAL,res.get("pantallas.literal.auxilExterno") + " - " + res.get("pantallas.literal.participacion"),socio.getParticipa(),idioma,100.00);
				if(numErrors<errors.size())
					valida3=false;
			}
		}
		
		//Valida que si se ha introducido algun dato en alguna fila, se obligue a introducir el Identificador(CIF/NIF).		
		z = 0;
		socio = null;
		valida1 = true;
		while (valida1 && z<numAuxExternos){
			socio = (P06B22T00Datatype)objListas.getListaAuxExternos().get(z);
			if (
				(socio.getIdentificador()==null || socio.getIdentificador().trim().equals("")) 
				&& (
                    (socio.getRazSoc()!=null && !socio.getRazSoc().trim().equals(""))
					|| (socio.getNombre()!=null && !socio.getNombre().trim().equals(""))
					|| (socio.getApe1()!=null && !socio.getApe1().trim().equals(""))
					|| (socio.getApe2()!=null && !socio.getApe2().trim().equals(""))
					|| (socio.getDomici()!=null && !socio.getDomici().trim().equals(""))
					|| (socio.getCodmun()!=null && !socio.getCodmun().trim().equals(""))
					|| (socio.getLocali()!=null && !socio.getLocali().trim().equals(""))
					|| (socio.getCodpro()!=null && !socio.getCodpro().trim().equals(""))
					|| (socio.getCodpst()!=null && !socio.getCodpst().trim().equals(""))
					|| (socio.getFecAlta()!=null && !socio.getFecAlta().trim().equals(""))
					|| (socio.getFecBaja()!=null && !socio.getFecBaja().trim().equals(""))
					|| (socio.getParticipa()!=null && !socio.getParticipa().trim().equals(""))
					)
				){
				errors=this.insertaError(errors, res.get("pantallas.literal.auxilExterno") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0015);
				valida1=false;
			}
			z++;
		}

		//Valida que el campo Identificador(CIF/NIF) no est repetido
		z = 0;
		socio = null;
		valida1 = true;
		i = 0;
		socio2 = null;
		while (valida1 && z<numAuxExternos){
			i = 0;
			socio = (P06B22T00Datatype)objListas.getListaAuxExternos().get(z);
			while (valida1 && i<numAuxExternos){
				if (i!=z){
					socio2 = (P06B22T00Datatype)objListas.getListaAuxExternos().get(i);
					if (socio.getIdentificador()!=null && !socio.getIdentificador().trim().equals("") && socio2.getIdentificador()!=null && !socio2.getIdentificador().trim().equals("") && socio.getIdentificador().trim().equals(socio2.getIdentificador().trim())){
						errors=this.insertaError(errors, res.get("pantallas.literal.auxilExterno") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0016);
						valida1=false;
					}
				}				
				i++;
			}
			z++;
		}
		//FIN PESTAA - AUXILIARES EXTERNOS
		
		
		//PESTAA - ORGANOS
		int numOrganos = objListas.getListaOrganos().size();
		z=0;
		numErrors = 0;
		P06B24T00Datatype organo = null;
		valida1 = true; 
		valida2 = true; 
		valida3 = true;
		
		boolean valida4 = true; 
		boolean valida5 = true;
		boolean valida6 = true;
		boolean valida7 = true;
		boolean valida8 = true;
		boolean valida9 = true;
		boolean valida10 = true;
		boolean valida11 = true;
		boolean valida12 = true;
		boolean valida13 = true;
		for(z=0;z<numOrganos;z++){
			organo = (P06B24T00Datatype)objListas.getListaOrganos().get(z);
			
			//La fecha de nombramiento --> Fecha vlida
			numErrors = errors.size();
			if(valida1){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.fNombr"),organo.getFechNom(),idioma);
				if(numErrors<errors.size())
					valida1=false;
			}
			
			//La fecha de suspension --> Fecha vlida
			numErrors = errors.size();
			if(valida2){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.fSuspen"),organo.getFecSus(),idioma);
				if(numErrors<errors.size())
					valida2=false;
			}
			
			//La fecha levantamiento suspension --> Fecha vlida
			numErrors = errors.size();
			if(valida3){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.fLevSuspen"),organo.getFecLeSus(),idioma);
				if(numErrors<errors.size())
					valida3=false;
			}
			
			//La fecha revocacin --> Fecha vlida
			numErrors = errors.size();
			if(valida4){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.fRevoc"),organo.getFecRev(),idioma);
				if(numErrors<errors.size())
					valida4=false;
			}
			
			//La fecha inhabilitacion --> Fecha vlida
			numErrors = errors.size();
			if(valida5){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.fInhabil"),organo.getFecInha(),idioma);
				if(numErrors<errors.size())
					valida5=false;
			}
			
			//La fecha cese --> Fecha vlida
			numErrors = errors.size();
			if(valida6){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.fCese"),organo.getFecCese(),idioma);
				if(numErrors<errors.size())
					valida6=false;
			}
			
			//Duracion inhabilitacion --> Entero
			numErrors = errors.size();
			if(valida7){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.duracInhabil"),organo.getDurHab(),idioma);
				if(numErrors<errors.size())
					valida7=false;
			}
			
			//Area de texto Sanciones - Comprobar longitud
			numErrors = errors.size();
			if(valida8){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.sanciones"),organo.getSanciones(),idioma,100);
				if(numErrors<errors.size())
					valida8=false;
			}
			//Area de texto Vinculaciones - Comprobar longitud
			numErrors = errors.size();
			if(valida9){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.vinculaciones"),organo.getVinculaciones(),idioma,250);
				if(numErrors<errors.size())
					valida9=false;
			}
			//Area de texto Entidad Aseguradora Autorizante - Comprobar longitud
			numErrors = errors.size();
			if(valida10){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.entAsegAutor"),organo.getEnAseAutori(),idioma,100);
				if(numErrors<errors.size())
					valida10=false;
			}
			//Area de texto Curso Formacin - Comprobar longitud
			numErrors = errors.size();
			if(valida11){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.cursoFormacion"),organo.getDenCurso(),idioma,250);
				if(numErrors<errors.size())
					valida11=false;
			}
			//Area de texto Acreditacin Honorabilidad - Comprobar longitud
			numErrors = errors.size();
			if(valida12){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.acredHonorabilidad"),organo.getDAcreditaH(),idioma,250);
				if(numErrors<errors.size())
					valida12=false;
			}
			//Area de texto Acreditacin Experiencia Administrador - Comprobar longitud
			numErrors = errors.size();
			if(valida13){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.acredExperiencia"),organo.getDAcredita(),idioma,250);
				if(numErrors<errors.size())
					valida13=false;
			}
		}
		
		//Valida que si se ha introducido algun dato en alguna fila, se obligue a introducir el Identificador (nif/cif) y el CARGO.		
		z = 0;
		organo = null;
		valida1 = true;
		while (valida1 && z<numOrganos){
			organo = (P06B24T00Datatype)objListas.getListaOrganos().get(z);
			if (
					(organo.getIdentificador()==null || organo.getIdentificador().trim().equals("") || ( !P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_ALTA.equals(request.getParameter("Estado")) && ( organo.getIdCargo()==null || organo.getIdCargo().trim().equals("") || organo.getIdCargo().trim().equals("0"))) )
					&& (
							(organo.getNombre()!=null && !organo.getNombre().trim().equals(""))
							|| (organo.getApe1()!=null && !organo.getApe1().trim().equals(""))
							|| (organo.getApe2()!=null && !organo.getApe2().trim().equals(""))
							|| (organo.getIdentificador()!=null && !organo.getIdentificador().trim().equals(""))
							|| (organo.getDomici()!=null && !organo.getDomici().trim().equals(""))
							|| (organo.getCodmun()!=null && !organo.getCodmun().trim().equals(""))
							|| (organo.getLocali()!=null && !organo.getLocali().trim().equals(""))
							|| (organo.getCodpro()!=null && !organo.getCodpro().trim().equals(""))
							|| (organo.getCodpst()!=null && !organo.getCodpst().trim().equals(""))
							|| (organo.getPais()!=null && !organo.getPais().trim().equals(""))
							|| (organo.getProfesi()!=null && !organo.getProfesi().trim().equals(""))
							|| (organo.getDenCurso()!=null && !organo.getDenCurso().trim().equals(""))
							|| (organo.getFecSus()!=null && !organo.getFecSus().trim().equals(""))
							|| (organo.getFecLeSus()!=null && !organo.getFecLeSus().trim().equals(""))
							|| (organo.getFecRev()!=null && !organo.getFecRev().trim().equals(""))
							|| (organo.getFecInha()!=null && !organo.getFecInha().trim().equals(""))
							|| (organo.getDurHab()!=null && !organo.getDurHab().trim().equals(""))
							|| (organo.getSanciones()!=null && !organo.getSanciones().trim().equals(""))
							|| (organo.getDAcredita()!=null && !organo.getDAcredita().trim().equals(""))
							|| (organo.getDAcreditaH()!=null && !organo.getDAcreditaH().trim().equals(""))
							|| (organo.getVinculaciones()!=null && !organo.getVinculaciones().trim().equals(""))
							|| (organo.getEnAseAutori()!=null && !organo.getEnAseAutori().trim().equals(""))
							|| (organo.getIdCargo()!=null && !organo.getIdCargo().trim().equals(""))
							|| (organo.getFechNom()!=null && !organo.getFechNom().trim().equals(""))
							|| (organo.getFecCese()!=null && !organo.getFecCese().trim().equals(""))
						)
				){
				errors=this.insertaError(errors, res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0021);
				valida1=false;
			}
			z++;
		}

		//Valida que el campo Identificador(nif/cif) y cargo no est repetido
		z = 0;
		organo = null;
		valida1 = true;
		i = 0;
		P06B24T00Datatype organo2 = null;
		while (valida1 && z<numOrganos){
			i = 0;
			organo = (P06B24T00Datatype)objListas.getListaOrganos().get(z);
			while (valida1 && i<numOrganos){
				if (i!=z){
					organo2 = (P06B24T00Datatype)objListas.getListaOrganos().get(i);
					if (organo.getIdentificador()!=null && !organo.getIdentificador().trim().equals("") && organo2.getIdentificador()!=null && !organo2.getIdentificador().trim().equals("") && organo.getIdentificador().trim().equals(organo2.getIdentificador().trim())
							&& organo.getIdCargo()!=null && !organo.getIdCargo().trim().equals("") && organo2.getIdCargo()!=null && !organo2.getIdCargo().trim().equals("") && organo.getIdCargo().trim().equals(organo2.getIdCargo().trim()) ){
						errors=this.insertaError(errors, res.get("pantallas.literal.direcResponMediac") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0022);
						valida1=false;
					}
				}				
				i++;
			}
			z++;
		}		
		//FIN PESTAA - ORGANOS
		
		
		//PESTAA - DIRECCION TECNICA
		numOrganos = objListas.getListaDirecTec().size();
		z=0;
		numErrors = 0;
		organo = null;
		valida1 = true; 
		valida2 = true; 
		valida3 = true;
		valida4 = true; 
		valida5 = true;
		valida6 = true;
		valida7 = true;
		valida8 = true;
		valida9 = true;
		valida10 = true;
		valida11 = true;
		valida12 = true;
		valida13 = true;
		for(z=0;z<numOrganos;z++){
			organo = (P06B24T00Datatype)objListas.getListaDirecTec().get(z);
			
			//La fecha de nombramiento --> Fecha vlida
			numErrors = errors.size();
			if(valida1){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.fNombr"),organo.getFechNom(),idioma);
				if(numErrors<errors.size())
					valida1=false;
			}
			
			//La fecha de suspension --> Fecha vlida
			numErrors = errors.size();
			if(valida2){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.fSuspen"),organo.getFecSus(),idioma);
				if(numErrors<errors.size())
					valida2=false;
			}
			
			//La fecha levantamiento suspension --> Fecha vlida
			numErrors = errors.size();
			if(valida3){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.fLevSuspen"),organo.getFecLeSus(),idioma);
				if(numErrors<errors.size())
					valida3=false;
			}
			
			//La fecha revocacin --> Fecha vlida
			numErrors = errors.size();
			if(valida4){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.fRevoc"),organo.getFecRev(),idioma);
				if(numErrors<errors.size())
					valida4=false;
			}
			
			//La fecha inhabilitacion --> Fecha vlida
			numErrors = errors.size();
			if(valida5){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.fInhabil"),organo.getFecInha(),idioma);
				if(numErrors<errors.size())
					valida5=false;
			}
			
			//La fecha cese --> Fecha vlida
			numErrors = errors.size();
			if(valida6){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.fCese"),organo.getFecCese(),idioma);
				if(numErrors<errors.size())
					valida6=false;
			}
			
			//Duracion inhabilitacion --> Entero
			numErrors = errors.size();
			if(valida7){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.duracInhabil"),organo.getDurHab(),idioma);
				if(numErrors<errors.size())
					valida7=false;
			}
			
			//Area de texto Sanciones - Comprobar longitud
			numErrors = errors.size();
			if(valida8){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.sanciones"),organo.getSanciones(),idioma,100);
				if(numErrors<errors.size())
					valida8=false;
			}
			//Area de texto Vinculaciones - Comprobar longitud
			numErrors = errors.size();
			if(valida9){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.vinculaciones"),organo.getVinculaciones(),idioma,250);
				if(numErrors<errors.size())
					valida9=false;
			}
			//Area de texto Entidad Aseguradora Autorizante - Comprobar longitud
			numErrors = errors.size();
			if(valida10){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.entAsegAutor"),organo.getEnAseAutori(),idioma,100);
				if(numErrors<errors.size())
					valida10=false;
			}
			//Area de texto Curso Formacin - Comprobar longitud
			numErrors = errors.size();
			if(valida11){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.cursoFormacion"),organo.getDenCurso(),idioma,250);
				if(numErrors<errors.size())
					valida11=false;
			}
			//Area de texto Acreditacin Honorabilidad - Comprobar longitud
			numErrors = errors.size();
			if(valida12){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.acredHonorabilidad"),organo.getDAcreditaH(),idioma,250);
				if(numErrors<errors.size())
					valida12=false;
			}
			//Area de texto Acreditacin Experiencia Administrador - Comprobar longitud
			numErrors = errors.size();
			if(valida13){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.acredExperiencia"),organo.getDAcredita(),idioma,250);
				if(numErrors<errors.size())
					valida13=false;
			}
		}
		
		//Valida que si se ha introducido algun dato en alguna fila, se obligue a introducir el Identificador (nif/cif) y el CARGO.		
		z = 0;
		organo = null;
		valida1 = true;
		while (valida1 && z<numOrganos){
			organo = (P06B24T00Datatype)objListas.getListaDirecTec().get(z);
			if (
					(organo.getIdentificador()==null || organo.getIdentificador().trim().equals("") || organo.getIdCargo()==null || organo.getIdCargo().trim().equals("") || organo.getIdCargo().trim().equals("0"))
					&& (
							(organo.getNombre()!=null && !organo.getNombre().trim().equals(""))
							|| (organo.getApe1()!=null && !organo.getApe1().trim().equals(""))
							|| (organo.getApe2()!=null && !organo.getApe2().trim().equals(""))
							|| (organo.getIdentificador()!=null && !organo.getIdentificador().trim().equals(""))
							|| (organo.getDomici()!=null && !organo.getDomici().trim().equals(""))
							|| (organo.getCodmun()!=null && !organo.getCodmun().trim().equals(""))
							|| (organo.getLocali()!=null && !organo.getLocali().trim().equals(""))
							|| (organo.getCodpro()!=null && !organo.getCodpro().trim().equals(""))
							|| (organo.getCodpst()!=null && !organo.getCodpst().trim().equals(""))
							|| (organo.getPais()!=null && !organo.getPais().trim().equals(""))
							|| (organo.getProfesi()!=null && !organo.getProfesi().trim().equals(""))
							|| (organo.getDenCurso()!=null && !organo.getDenCurso().trim().equals(""))
							|| (organo.getFecSus()!=null && !organo.getFecSus().trim().equals(""))
							|| (organo.getFecLeSus()!=null && !organo.getFecLeSus().trim().equals(""))
							|| (organo.getFecRev()!=null && !organo.getFecRev().trim().equals(""))
							|| (organo.getFecInha()!=null && !organo.getFecInha().trim().equals(""))
							|| (organo.getDurHab()!=null && !organo.getDurHab().trim().equals(""))
							|| (organo.getSanciones()!=null && !organo.getSanciones().trim().equals(""))
							|| (organo.getDAcredita()!=null && !organo.getDAcredita().trim().equals(""))
							|| (organo.getDAcreditaH()!=null && !organo.getDAcreditaH().trim().equals(""))
							|| (organo.getVinculaciones()!=null && !organo.getVinculaciones().trim().equals(""))
							|| (organo.getEnAseAutori()!=null && !organo.getEnAseAutori().trim().equals(""))
							|| (organo.getIdCargo()!=null && !organo.getIdCargo().trim().equals(""))
							|| (organo.getFechNom()!=null && !organo.getFechNom().trim().equals(""))
							|| (organo.getFecCese()!=null && !organo.getFecCese().trim().equals(""))
						)
				){
				errors=this.insertaError(errors, res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0021);
				valida1=false;
			}
			z++;
		}

		//Valida que el campo Identificador(nif/cif) y cargo no est repetido
		z = 0;
		organo = null;
		valida1 = true;
		i = 0;
		organo2 = null;
		while (valida1 && z<numOrganos){
			i = 0;
			organo = (P06B24T00Datatype)objListas.getListaDirecTec().get(z);
			while (valida1 && i<numOrganos){
				if (i!=z){
					organo2 = (P06B24T00Datatype)objListas.getListaDirecTec().get(i);
					if (organo.getIdentificador()!=null && !organo.getIdentificador().trim().equals("") && organo2.getIdentificador()!=null && !organo2.getIdentificador().trim().equals("") && organo.getIdentificador().trim().equals(organo2.getIdentificador().trim())
							&& organo.getIdCargo()!=null && !organo.getIdCargo().trim().equals("") && organo2.getIdCargo()!=null && !organo2.getIdCargo().trim().equals("") && organo.getIdCargo().trim().equals(organo2.getIdCargo().trim()) ){
						errors=this.insertaError(errors, res.get("pantallas.literal.direcTecnica") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0022);
						valida1=false;
					}
				}				
				i++;
			}
			z++;
		}		
		//FIN PESTAA - DRIECCION TECNICA
		
				
		//PESTAA - OTROS DIRECCION
		numOrganos = objListas.getListaOtrosDirec().size();
		z=0;
		numErrors = 0;
		organo = null;
		valida1 = true; 
		valida2 = true; 
		valida3 = true;
		
		valida4 = true; 
		valida5 = true;
		valida6 = true;
		valida7 = true;
		valida8 = true;
		valida9 = true;
		valida10 = true;
		valida11 = true;
		valida12 = true;
		valida13 = true;
		for(z=0;z<numOrganos;z++){
			organo = (P06B24T00Datatype)objListas.getListaOtrosDirec().get(z);
			
			//La fecha de nombramiento --> Fecha vlida
			numErrors = errors.size();
			if(valida1){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.fNombr"),organo.getFechNom(),idioma);
				if(numErrors<errors.size())
					valida1=false;
			}
			
			//La fecha de suspension --> Fecha vlida
			numErrors = errors.size();
			if(valida2){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.fSuspen"),organo.getFecSus(),idioma);
				if(numErrors<errors.size())
					valida2=false;
			}
			
			//La fecha levantamiento suspension --> Fecha vlida
			numErrors = errors.size();
			if(valida3){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.fLevSuspen"),organo.getFecLeSus(),idioma);
				if(numErrors<errors.size())
					valida3=false;
			}
			
			//La fecha revocacin --> Fecha vlida
			numErrors = errors.size();
			if(valida4){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.fRevoc"),organo.getFecRev(),idioma);
				if(numErrors<errors.size())
					valida4=false;
			}
			
			//La fecha inhabilitacion --> Fecha vlida
			numErrors = errors.size();
			if(valida5){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.fInhabil"),organo.getFecInha(),idioma);
				if(numErrors<errors.size())
					valida5=false;
			}
			
			//La fecha cese --> Fecha vlida
			numErrors = errors.size();
			if(valida6){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.fCese"),organo.getFecCese(),idioma);
				if(numErrors<errors.size())
					valida6=false;
			}
			
			//Duracion inhabilitacion --> Entero
			numErrors = errors.size();
			if(valida7){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.duracInhabil"),organo.getDurHab(),idioma);
				if(numErrors<errors.size())
					valida7=false;
			}
			
			//Area de texto Sanciones - Comprobar longitud
			numErrors = errors.size();
			if(valida8){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.sanciones"),organo.getSanciones(),idioma,100);
				if(numErrors<errors.size())
					valida8=false;
			}
			//Area de texto Vinculaciones - Comprobar longitud
			numErrors = errors.size();
			if(valida9){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.vinculaciones"),organo.getVinculaciones(),idioma,250);
				if(numErrors<errors.size())
					valida9=false;
			}
			//Area de texto Entidad Aseguradora Autorizante - Comprobar longitud
			numErrors = errors.size();
			if(valida10){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.entAsegAutor"),organo.getEnAseAutori(),idioma,100);
				if(numErrors<errors.size())
					valida10=false;
			}
			//Area de texto Curso Formacin - Comprobar longitud
			numErrors = errors.size();
			if(valida11){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.cursoFormacion"),organo.getDenCurso(),idioma,250);
				if(numErrors<errors.size())
					valida11=false;
			}
			//Area de texto Acreditacin Honorabilidad - Comprobar longitud
			numErrors = errors.size();
			if(valida12){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.acredHonorabilidad"),organo.getDAcreditaH(),idioma,250);
				if(numErrors<errors.size())
					valida12=false;
			}
			//Area de texto Acreditacin Experiencia Administrador - Comprobar longitud
			numErrors = errors.size();
			if(valida13){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.acredExperiencia"),organo.getDAcredita(),idioma,250);
				if(numErrors<errors.size())
					valida13=false;
			}
		}
		
		//Valida que si se ha introducido algun dato en alguna fila, se obligue a introducir el Identificador (nif/cif) y el CARGO.		
		z = 0;
		organo = null;
		valida1 = true;
		while (valida1 && z<numOrganos){
			organo = (P06B24T00Datatype)objListas.getListaOtrosDirec().get(z);
			if (
					(organo.getIdentificador()==null || organo.getIdentificador().trim().equals("") || organo.getIdCargo()==null || organo.getIdCargo().trim().equals("") || organo.getIdCargo().trim().equals("0"))
					&& (
							(organo.getNombre()!=null && !organo.getNombre().trim().equals(""))
							|| (organo.getApe1()!=null && !organo.getApe1().trim().equals(""))
							|| (organo.getApe2()!=null && !organo.getApe2().trim().equals(""))
							|| (organo.getIdentificador()!=null && !organo.getIdentificador().trim().equals(""))
							|| (organo.getDomici()!=null && !organo.getDomici().trim().equals(""))
							|| (organo.getCodmun()!=null && !organo.getCodmun().trim().equals(""))
							|| (organo.getLocali()!=null && !organo.getLocali().trim().equals(""))
							|| (organo.getCodpro()!=null && !organo.getCodpro().trim().equals(""))
							|| (organo.getCodpst()!=null && !organo.getCodpst().trim().equals(""))
							|| (organo.getPais()!=null && !organo.getPais().trim().equals(""))
							|| (organo.getProfesi()!=null && !organo.getProfesi().trim().equals(""))
							|| (organo.getDenCurso()!=null && !organo.getDenCurso().trim().equals(""))
							|| (organo.getFecSus()!=null && !organo.getFecSus().trim().equals(""))
							|| (organo.getFecLeSus()!=null && !organo.getFecLeSus().trim().equals(""))
							|| (organo.getFecRev()!=null && !organo.getFecRev().trim().equals(""))
							|| (organo.getFecInha()!=null && !organo.getFecInha().trim().equals(""))
							|| (organo.getDurHab()!=null && !organo.getDurHab().trim().equals(""))
							|| (organo.getSanciones()!=null && !organo.getSanciones().trim().equals(""))
							|| (organo.getDAcredita()!=null && !organo.getDAcredita().trim().equals(""))
							|| (organo.getDAcreditaH()!=null && !organo.getDAcreditaH().trim().equals(""))
							|| (organo.getVinculaciones()!=null && !organo.getVinculaciones().trim().equals(""))
							|| (organo.getEnAseAutori()!=null && !organo.getEnAseAutori().trim().equals(""))
							|| (organo.getIdCargo()!=null && !organo.getIdCargo().trim().equals(""))
							|| (organo.getFechNom()!=null && !organo.getFechNom().trim().equals(""))
							|| (organo.getFecCese()!=null && !organo.getFecCese().trim().equals(""))
						)
				){
				errors=this.insertaError(errors, res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0021);
				valida1=false;
			}
			z++;
		}

		//Valida que el campo Identificador(nif/cif) y cargo no est repetido
		z = 0;
		organo = null;
		valida1 = true;
		i = 0;
		organo2 = null;
		while (valida1 && z<numOrganos){
			i = 0;
			organo = (P06B24T00Datatype)objListas.getListaOtrosDirec().get(z);
			while (valida1 && i<numOrganos){
				if (i!=z){
					organo2 = (P06B24T00Datatype)objListas.getListaOtrosDirec().get(i);
					if (organo.getIdentificador()!=null && !organo.getIdentificador().trim().equals("") && organo2.getIdentificador()!=null && !organo2.getIdentificador().trim().equals("") && organo.getIdentificador().trim().equals(organo2.getIdentificador().trim())
							&& organo.getIdCargo()!=null && !organo.getIdCargo().trim().equals("") && organo2.getIdCargo()!=null && !organo2.getIdCargo().trim().equals("") && organo.getIdCargo().trim().equals(organo2.getIdCargo().trim()) ){
						errors=this.insertaError(errors, res.get("pantallas.literal.particDirectosMediac") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0022);
						valida1=false;
					}
				}				
				i++;
			}
			z++;
		}		
		//FIN PESTAA - OTROS DIRECCION
		
		
		//PESTAA - ADMINISTRADORES
		numOrganos = objListas.getListaAdministradores().size();
		z=0;
		numErrors = 0;
		organo = null;
		valida1 = true; 
		valida2 = true; 
		valida3 = true;
		
		valida4 = true; 
		valida5 = true;
		valida6 = true;
		valida7 = true;
		valida8 = true;
		valida9 = true;
		valida10 = true;
		valida11 = true;
		valida12 = true;
		valida13 = true;
		for(z=0;z<numOrganos;z++){
			organo = (P06B24T00Datatype)objListas.getListaAdministradores().get(z);
			
			//La fecha de nombramiento --> Fecha vlida
			numErrors = errors.size();
			if(valida1){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.fNombr"),organo.getFechNom(),idioma);
				if(numErrors<errors.size())
					valida1=false;
			}
			
			//La fecha de suspension --> Fecha vlida
			numErrors = errors.size();
			if(valida2){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.fSuspen"),organo.getFecSus(),idioma);
				if(numErrors<errors.size())
					valida2=false;
			}
			
			//La fecha levantamiento suspension --> Fecha vlida
			numErrors = errors.size();
			if(valida3){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.fLevSuspen"),organo.getFecLeSus(),idioma);
				if(numErrors<errors.size())
					valida3=false;
			}
			
			//La fecha revocacin --> Fecha vlida
			numErrors = errors.size();
			if(valida4){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.fRevoc"),organo.getFecRev(),idioma);
				if(numErrors<errors.size())
					valida4=false;
			}
			
			//La fecha inhabilitacion --> Fecha vlida
			numErrors = errors.size();
			if(valida5){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.fInhabil"),organo.getFecInha(),idioma);
				if(numErrors<errors.size())
					valida5=false;
			}
			
			//La fecha cese --> Fecha vlida
			numErrors = errors.size();
			if(valida6){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.FECHA,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.fCese"),organo.getFecCese(),idioma);
				if(numErrors<errors.size())
					valida6=false;
			}
			
			//Duracion inhabilitacion --> Entero
			numErrors = errors.size();
			if(valida7){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.duracInhabil"),organo.getDurHab(),idioma);
				if(numErrors<errors.size())
					valida7=false;
			}
			
			//Area de texto Sanciones - Comprobar longitud
			numErrors = errors.size();
			if(valida8){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.sanciones"),organo.getSanciones(),idioma,100);
				if(numErrors<errors.size())
					valida8=false;
			}
			//Area de texto Vinculaciones - Comprobar longitud
			numErrors = errors.size();
			if(valida9){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.vinculaciones"),organo.getVinculaciones(),idioma,250);
				if(numErrors<errors.size())
					valida9=false;
			}
			//Area de texto Entidad Aseguradora Autorizante - Comprobar longitud
			numErrors = errors.size();
			if(valida10){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.entAsegAutor"),organo.getEnAseAutori(),idioma,100);
				if(numErrors<errors.size())
					valida10=false;
			}
			//Area de texto Curso Formacin - Comprobar longitud
			numErrors = errors.size();
			if(valida11){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.cursoFormacion"),organo.getDenCurso(),idioma,250);
				if(numErrors<errors.size())
					valida11=false;
			}
			//Area de texto Acreditacin Honorabilidad - Comprobar longitud
			numErrors = errors.size();
			if(valida12){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.acredHonorabilidad"),organo.getDAcreditaH(),idioma,250);
				if(numErrors<errors.size())
					valida12=false;
			}
			//Area de texto Acreditacin Experiencia Administrador - Comprobar longitud
			numErrors = errors.size();
			if(valida13){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.CMPLONGITUD,res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.acredExperiencia"),organo.getDAcredita(),idioma,250);
				if(numErrors<errors.size())
					valida13=false;
			}
		}
		
		//Valida que si se ha introducido algun dato en alguna fila, se obligue a introducir el Identificador (nif/cif) y el CARGO.		
		z = 0;
		organo = null;
		valida1 = true;
		while (valida1 && z<numOrganos){
			organo = (P06B24T00Datatype)objListas.getListaAdministradores().get(z);
			if (
					(organo.getIdentificador()==null || organo.getIdentificador().trim().equals("") || ( !P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_ALTA.equals(request.getParameter("Estado")) && ( organo.getIdCargo()==null || organo.getIdCargo().trim().equals("") || organo.getIdCargo().trim().equals("0")) ) )
					&& (
							(organo.getNombre()!=null && !organo.getNombre().trim().equals(""))
							|| (organo.getApe1()!=null && !organo.getApe1().trim().equals(""))
							|| (organo.getApe2()!=null && !organo.getApe2().trim().equals(""))
							|| (organo.getIdentificador()!=null && !organo.getIdentificador().trim().equals(""))
							|| (organo.getDomici()!=null && !organo.getDomici().trim().equals(""))
							|| (organo.getCodmun()!=null && !organo.getCodmun().trim().equals(""))
							|| (organo.getLocali()!=null && !organo.getLocali().trim().equals(""))
							|| (organo.getCodpro()!=null && !organo.getCodpro().trim().equals(""))
							|| (organo.getCodpst()!=null && !organo.getCodpst().trim().equals(""))
							|| (organo.getPais()!=null && !organo.getPais().trim().equals(""))
							|| (organo.getProfesi()!=null && !organo.getProfesi().trim().equals(""))
							|| (organo.getDenCurso()!=null && !organo.getDenCurso().trim().equals(""))
							|| (organo.getFecSus()!=null && !organo.getFecSus().trim().equals(""))
							|| (organo.getFecLeSus()!=null && !organo.getFecLeSus().trim().equals(""))
							|| (organo.getFecRev()!=null && !organo.getFecRev().trim().equals(""))
							|| (organo.getFecInha()!=null && !organo.getFecInha().trim().equals(""))
							|| (organo.getDurHab()!=null && !organo.getDurHab().trim().equals(""))
							|| (organo.getSanciones()!=null && !organo.getSanciones().trim().equals(""))
							|| (organo.getDAcredita()!=null && !organo.getDAcredita().trim().equals(""))
							|| (organo.getDAcreditaH()!=null && !organo.getDAcreditaH().trim().equals(""))
							|| (organo.getVinculaciones()!=null && !organo.getVinculaciones().trim().equals(""))
							|| (organo.getEnAseAutori()!=null && !organo.getEnAseAutori().trim().equals(""))
							|| (organo.getIdCargo()!=null && !organo.getIdCargo().trim().equals(""))
							|| (organo.getFechNom()!=null && !organo.getFechNom().trim().equals(""))
							|| (organo.getFecCese()!=null && !organo.getFecCese().trim().equals(""))
						)
				){
				errors=this.insertaError(errors, res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0021);
				valida1=false;
			}
			z++;
		}

		//Valida que el campo Identificador(nif/cif) y cargo no est repetido
		z = 0;
		organo = null;
		valida1 = true;
		i = 0;
		organo2 = null;
		while (valida1 && z<numOrganos){
			i = 0;
			organo = (P06B24T00Datatype)objListas.getListaAdministradores().get(z);
			while (valida1 && i<numOrganos){
				if (i!=z){
					organo2 = (P06B24T00Datatype)objListas.getListaAdministradores().get(i);
					if (organo.getIdentificador()!=null && !organo.getIdentificador().trim().equals("") && organo2.getIdentificador()!=null && !organo2.getIdentificador().trim().equals("") && organo.getIdentificador().trim().equals(organo2.getIdentificador().trim())
							&& organo.getIdCargo()!=null && !organo.getIdCargo().trim().equals("") && organo2.getIdCargo()!=null && !organo2.getIdCargo().trim().equals("") && organo.getIdCargo().trim().equals(organo2.getIdCargo().trim()) ){
						errors=this.insertaError(errors, res.get("pantallas.literal.admin") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0022);
						valida1=false;
					}
				}				
				i++;
			}
			z++;
		}		
		//FIN PESTAA - ADMINISTRADORES
		
		
		//PESTAA SUCURSALES
		
		int numSucursales = objListas.getListaSucursales().size();
		z=0;
		numErrors = 0;
		P06B25T00Datatype sucursal = null;
		valida1 = true; 
		valida2 = true; 
		valida3 = true;
		valida4 = true; 
		valida5 = true;
		valida6 = true;
		valida7 = true;
		for(z=0;z<numSucursales;z++){
			sucursal = (P06B25T00Datatype)objListas.getListaSucursales().get(z);
			
			//Campo Cdigo Postal -> Entero
			numErrors = errors.size();
			if(valida1){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.sucur") + " - " + res.get("pantallas.literal.codigoPostal"),sucursal.getCodpst(),idioma);
				if(numErrors<errors.size())
					valida1=false;
			}
			
			//Telfono 1
			numErrors = errors.size();
			if(valida2){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.sucur") + " - " + res.get("pantallas.literal.tfno1"),sucursal.getTelefot(),idioma);
				if(numErrors<errors.size())
					valida2=false;
			}
			
			//Telfono 2
			numErrors = errors.size();
			if(valida3){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.sucur") + " - " + res.get("pantallas.literal.tfno2"),sucursal.getTelefom(),idioma);
				if(numErrors<errors.size())
					valida3=false;
			}
			
			//Telfono 3
			numErrors = errors.size();
			if(valida4){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.sucur") + " - " + res.get("pantallas.literal.tfno3"),sucursal.getTelefoc(),idioma);
				if(numErrors<errors.size())
					valida4=false;
			}
			
			//Fax 1
			numErrors = errors.size();
			if(valida5){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.sucur") + " - " + res.get("pantallas.literal.fax1"),sucursal.getFax1(),idioma);
				if(numErrors<errors.size())
					valida5=false;
			}
			
			//Fax 2
			numErrors = errors.size();
			if(valida6){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.sucur") + " - " + res.get("pantallas.literal.fax2"),sucursal.getFax2(),idioma);
				if(numErrors<errors.size())
					valida6=false;
			}
			
			//Campo de mail
			numErrors = errors.size();
			if(valida7){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.MAIL,res.get("pantallas.literal.sucur") + " - " + res.get("pantallas.literal.mail"),sucursal.getMail(),idioma);
				if(numErrors<errors.size())
					valida7=false;
			}
			
		}
			
		//FIN PESTAA SUCURSALES
		
		
		//DEFENSORES de CLIENTE
		int numDefCliente = objListas.getListaDefCliente().size();
		z=0;
		numErrors = 0;
		P06B29T00Datatype defCliente = null;
		P06B30T00Datatype defPFCliente = null;
		valida1 = true; 
		valida2 = true; 
		valida3 = true;
		valida4 = true; 
		valida5 = true;
		valida6 = true;
		valida7 = true;
		valida8 = true;
				
		ArrayList listaPF_DefCliente = null;
		for(z=0;z<numDefCliente;z++){
			listaPF_DefCliente = null;
			defCliente = (P06B29T00Datatype)objListas.getListaDefCliente().get(z);
			
			//Campo Cdigo Postal -> Entero
			numErrors = errors.size();
			if(valida1){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.defAtCliente") + " - " + res.get("pantallas.literal.codigoPostal"),defCliente.getCodpst(),idioma);
				if(numErrors<errors.size())
					valida1=false;
			}
			
			//Telfono 1
			numErrors = errors.size();
			if(valida2){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.defAtCliente") + " - " + res.get("pantallas.literal.tfno1"),defCliente.getTelefot(),idioma);
				if(numErrors<errors.size())
					valida2=false;
			}
			
			//Telfono 2
			numErrors = errors.size();
			if(valida3){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.defAtCliente") + " - " + res.get("pantallas.literal.tfno2"),defCliente.getTelefom(),idioma);
				if(numErrors<errors.size())
					valida3=false;
			}
			
			//Telfono 3
			numErrors = errors.size();
			if(valida4){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.defAtCliente") + " - " + res.get("pantallas.literal.tfno3"),defCliente.getTelefoc(),idioma);
				if(numErrors<errors.size())
					valida4=false;
			}
			
			//Fax 1
			numErrors = errors.size();
			if(valida5){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.defAtCliente") + " - " + res.get("pantallas.literal.fax1"),defCliente.getFax1(),idioma);
				if(numErrors<errors.size())
					valida5=false;
			}
			
			//Fax 2
			numErrors = errors.size();
			if(valida6){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.defAtCliente") + " - " + res.get("pantallas.literal.fax2"),defCliente.getFax2(),idioma);
				if(numErrors<errors.size())
					valida6=false;
			}
			
			//Campo de mail
			numErrors = errors.size();
			if(valida7){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.MAIL,res.get("pantallas.literal.defAtCliente") + " - " + res.get("pantallas.literal.mail"),defCliente.getMail(),idioma);
				if(numErrors<errors.size())
					valida7=false;
			}
			
			//Comprobar el cdigo postal de la lista de personas fsicas correspondiente al defensor de cliente
			listaPF_DefCliente = defCliente.getListaPF_DefCliente();
			
			if (valida8 && listaPF_DefCliente != null && listaPF_DefCliente.size() > 0){
				for(int zz=0;zz<listaPF_DefCliente.size();zz++){
					defPFCliente = (P06B30T00Datatype)listaPF_DefCliente.get(zz);
					
					//Campo Cdigo Postal -> Entero
					numErrors = errors.size();
					if(valida8){
						errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.defAtCliente") + " - " + res.get("pantallas.literal.persFisica") + " - " + res.get("pantallas.literal.codigoPostal"),defPFCliente.getCodpst(),idioma);
						if(numErrors<errors.size())
							valida8=false;
					}					
				}
			}			
		}
				
		//Valida que el campo Identificador(nif/cif) no est repetido
		z = 0;
		defCliente = null;
		defPFCliente = null;
		listaPF_DefCliente = null;
		valida1 = true;
		valida2 = true;
		i = 0;
		int zzz = 0;
		int iii = 0;
		
		P06B29T00Datatype defCliente2 = null;
		P06B30T00Datatype defPFCliente2 = null;
		while ((valida1 || valida2) && z<numDefCliente){
			listaPF_DefCliente = null;
			i = 0;
			zzz = 0;
			iii = 0;
			defCliente = (P06B29T00Datatype)objListas.getListaDefCliente().get(z);
			while (valida1 && i<numDefCliente){
				if (i!=z){
					defCliente2 = (P06B29T00Datatype)objListas.getListaDefCliente().get(i);
					if (defCliente.getIdentificador()!=null && !defCliente.getIdentificador().trim().equals("") && defCliente2.getIdentificador()!=null && !defCliente2.getIdentificador().trim().equals("") && defCliente.getIdentificador().trim().equals(defCliente2.getIdentificador().trim())){
						errors=this.insertaError(errors, res.get("pantallas.literal.defAtCliente") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0016);
						valida1=false;
					}
				}				
				i++;
			}
			
			// Inicio : Valida que el campo Identificador(nif/cif) de la lista de personas fsicas del defensor de cliente, no est repetido
			listaPF_DefCliente = defCliente.getListaPF_DefCliente();
			
			if (valida2 && listaPF_DefCliente != null && listaPF_DefCliente.size() > 0){
			
				while (valida2 && zzz<listaPF_DefCliente.size()){
					iii = 0;
					defPFCliente = (P06B30T00Datatype)listaPF_DefCliente.get(zzz);
					while (valida2 && iii<listaPF_DefCliente.size()){
						if (iii!=zzz){
							defPFCliente2 = (P06B30T00Datatype)listaPF_DefCliente.get(iii);
							if (defPFCliente.getIdentificador1()!=null && !defPFCliente.getIdentificador1().trim().equals("") && defPFCliente2.getIdentificador1()!=null && !defPFCliente2.getIdentificador1().trim().equals("") && defPFCliente.getIdentificador1().trim().equals(defPFCliente2.getIdentificador1().trim())){
								errors=this.insertaError(errors, res.get("pantallas.literal.defAtCliente") + " - " + res.get("pantallas.literal.persFisica") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0016);
								valida2=false;
							}
						}				
						iii++;
					}	
					zzz++;
				}
			}
			// Fin : Valida que el campo Identificador(nif/cif) de la lista de personas fsicas del defensor de cliente, no est repetido
		
			z++;
		}
		
		//FIN DEFENSORES de CLIENTE
		
				
		//DEPARTAMENTO ATENCION CLIENTE
		int numDepAtCliente = objListas.getListaDepAtCliente().size();
		z=0;
		numErrors = 0;
		P06B26T00Datatype depAtCliente = null;
		P06B27T00Datatype depAtPFCliente = null;
		P06B28T00Datatype depAtRespCliente = null;
		valida1 = true; 
		valida2 = true; 
		valida3 = true;
		valida4 = true; 
		valida5 = true;
		valida6 = true;
		valida7 = true;
		valida8 = true;
		valida9 = true;
				
		ArrayList listaPF_DepAtCliente = null;
		ArrayList listaResp_DepAtCliente = null;
		for(z=0;z<numDepAtCliente;z++){
			listaPF_DepAtCliente = null;
			listaResp_DepAtCliente = null;
			depAtCliente = (P06B26T00Datatype)objListas.getListaDepAtCliente().get(z);
			
			//Campo Cdigo Postal -> Entero
			numErrors = errors.size();
			if(valida1){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.codigoPostal"),depAtCliente.getCodpst(),idioma);
				if(numErrors<errors.size())
					valida1=false;
			}
			
			
			//Comprobar el cdigo postal de la lista de personas fsicas correspondiente al departamento de atencin al cliente
			listaPF_DepAtCliente = depAtCliente.getListaPF_DepAtCliente();
			
			if (listaPF_DepAtCliente != null && listaPF_DepAtCliente.size() > 0){
				for(int zz=0;zz<listaPF_DepAtCliente.size();zz++){
					depAtPFCliente = (P06B27T00Datatype)listaPF_DepAtCliente.get(zz);
					
					//Campo Cdigo Postal -> Entero
					numErrors = errors.size();
					if(valida8){
						errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.persFisica") + " - " + res.get("pantallas.literal.codigoPostal"),depAtPFCliente.getCodpst(),idioma);
						if(numErrors<errors.size())
							valida8=false;
					}					
				}
			}
			
			
			//Comprobar los campos de la lista de responsables correspondiente al departamento de atencin al cliente
			listaResp_DepAtCliente = depAtCliente.getListaRespDepAtCl();
			
			if (listaResp_DepAtCliente != null && listaResp_DepAtCliente.size() > 0){
				for(int zz=0;zz<listaResp_DepAtCliente.size();zz++){
					depAtRespCliente = (P06B28T00Datatype)listaResp_DepAtCliente.get(zz);
					
					//Campo Cdigo Postal -> Entero
					numErrors = errors.size();
					if(valida9){
						errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.respDep") + " - " + res.get("pantallas.literal.codigoPostal"),depAtRespCliente.getCodpst(),idioma);
						if(numErrors<errors.size())
							valida9=false;
					}
					
					//Telfono 1
					numErrors = errors.size();
					if(valida2){
						errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.respDep") + " - " + res.get("pantallas.literal.tfno1"),depAtRespCliente.getTelefot(),idioma);
						if(numErrors<errors.size())
							valida2=false;
					}
					
					//Telfono 2
					numErrors = errors.size();
					if(valida3){
						errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.respDep") + " - " + res.get("pantallas.literal.tfno2"),depAtRespCliente.getTelefom(),idioma);
						if(numErrors<errors.size())
							valida3=false;
					}
					
					//Telfono 3
					numErrors = errors.size();
					if(valida4){
						errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.respDep") + " - " + res.get("pantallas.literal.tfno3"),depAtRespCliente.getTelefoc(),idioma);
						if(numErrors<errors.size())
							valida4=false;
					}
					
					//Fax 1
					numErrors = errors.size();
					if(valida5){
						errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.respDep") + " - " + res.get("pantallas.literal.fax1"),depAtRespCliente.getFax1(),idioma);
						if(numErrors<errors.size())
							valida5=false;
					}
					
					//Fax 2
					numErrors = errors.size();
					if(valida6){
						errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.TELEFONO,res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.respDep") + " - " + res.get("pantallas.literal.fax2"),depAtRespCliente.getFax2(),idioma);
						if(numErrors<errors.size())
							valida6=false;
					}
					
					//Campo de mail
					numErrors = errors.size();
					if(valida7){
						errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.MAIL,res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.respDep") + " - " + res.get("pantallas.literal.mail"),depAtRespCliente.getMail(),idioma);
						if(numErrors<errors.size())
							valida7=false;
					}
				}
			}
			
		}
				
		//Valida que el campo Identificador(nif/cif) no est repetido
		z = 0;
		depAtCliente = null;
		depAtPFCliente = null;
		depAtRespCliente = null;
		listaPF_DepAtCliente = null;
		listaResp_DepAtCliente = null;
		valida1 = true;
		valida2 = true;
		valida3 = true;
		i = 0;
		zzz = 0;
		iii = 0;
		
		P06B26T00Datatype depAtCliente2 = null;
		P06B27T00Datatype depAtPFCliente2 = null;
		P06B28T00Datatype depAtRespCliente2 = null;
		while ((valida1 || valida2  || valida3) && z<numDepAtCliente){
			listaPF_DepAtCliente = null;
			listaResp_DepAtCliente = null;
			i = 0;
			zzz = 0;
			iii = 0;
			depAtCliente = (P06B26T00Datatype)objListas.getListaDepAtCliente().get(z);
			while (valida1 && i<numDepAtCliente){
				if (i!=z){
					depAtCliente2 = (P06B26T00Datatype)objListas.getListaDepAtCliente().get(i);
					if (depAtCliente.getIdentificador()!=null && !depAtCliente.getIdentificador().trim().equals("") && depAtCliente2.getIdentificador()!=null && !depAtCliente2.getIdentificador().trim().equals("") && depAtCliente.getIdentificador().trim().equals(depAtCliente2.getIdentificador().trim())){
						errors=this.insertaError(errors, res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0016);
						valida1=false;
					}
				}				
				i++;
			}
			
			// Inicio : Valida que el campo Identificador(nif/cif) de la lista de personas fsicas del departamento de atencin al cliente, no est repetido
			listaPF_DepAtCliente = depAtCliente.getListaPF_DepAtCliente();
			
			if (valida2 && listaPF_DepAtCliente != null && listaPF_DepAtCliente.size() > 0){
			
				while (valida2 && zzz<listaPF_DepAtCliente.size()){
					iii = 0;
					depAtPFCliente = (P06B27T00Datatype)listaPF_DepAtCliente.get(zzz);
					while (valida2 && iii<listaPF_DepAtCliente.size()){
						if (iii!=zzz){
							depAtPFCliente2 = (P06B27T00Datatype)listaPF_DepAtCliente.get(iii);
							if (depAtPFCliente.getIdentificador1()!=null && !depAtPFCliente.getIdentificador1().trim().equals("") && depAtPFCliente2.getIdentificador1()!=null && !depAtPFCliente2.getIdentificador1().trim().equals("") && depAtPFCliente.getIdentificador1().trim().equals(depAtPFCliente2.getIdentificador1().trim())){
								errors=this.insertaError(errors, res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.persFisica") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0016);
								valida2=false;
							}
						}				
						iii++;
					}	
					zzz++;
				}
			}
			// Fin : Valida que el campo Identificador(nif/cif) de la lista de personas fsicas del departamento de atencin al cliente, no est repetido
			
			
			
			//Inicio : Valida que el campo Identificador(nif/cif) de la lista de responsables del departamento de at. cliente, no est repetido
			zzz = 0;
			iii = 0;
			listaResp_DepAtCliente = depAtCliente.getListaRespDepAtCl();
			
			if (valida3 && listaResp_DepAtCliente != null && listaResp_DepAtCliente.size() > 0){
			
				while (valida3 && zzz<listaResp_DepAtCliente.size()){
					iii = 0;
					depAtRespCliente = (P06B28T00Datatype)listaResp_DepAtCliente.get(zzz);
					while (valida3 && iii<listaResp_DepAtCliente.size()){
						if (iii!=zzz){
							depAtRespCliente2 = (P06B28T00Datatype)listaResp_DepAtCliente.get(iii);
							if (depAtRespCliente.getIdentificador1()!=null && !depAtRespCliente.getIdentificador1().trim().equals("") && depAtRespCliente2.getIdentificador1()!=null && !depAtRespCliente2.getIdentificador1().trim().equals("") && depAtRespCliente.getIdentificador1().trim().equals(depAtRespCliente2.getIdentificador1().trim())){
								errors=this.insertaError(errors, res.get("pantallas.literal.depAtCliente") + " - " + res.get("pantallas.literal.respDep") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0016);
								valida3=false;
							}
						}				
						iii++;
					}	
					zzz++;
				}
			}
			// Fin : Valida que el campo Identificador(nif/cif) de la lista de responsables del departamento de at. cliente, no est repetido
			
		
			z++;
		}
		
		//FIN DEPARTAMENTO ATENCION CLIENTE
		
				
		//PESTAA 12 - EMPRESAS VINCULADAS
		int numEVs = objListas.getListaEVs().size();		
		z=0;
		numErrors = 0;
		P06B61T00Datatype ev = null;
		valida1 = true;
		valida2 = true;
		valida3 = true;
		
		//Valida que si se ha introducido algun dato en alguna fila, se obligue a introducir el Identificador(CIF/NIF)		
		z = 0;
		ev = null;
		valida1 = true;
		while (valida1 && z<numEVs){
			ev = (P06B61T00Datatype)objListas.getListaEVs().get(z);
			if ((ev.getEntidad()!=null && !ev.getEntidad().trim().equals(""))
					|| (ev.getCalle()!=null && !ev.getCalle().trim().equals(""))
					|| (ev.getPortal()!=null && !ev.getPortal().trim().equals(""))
					|| (ev.getPiso()!=null && !ev.getPiso().trim().equals(""))
					|| (ev.getLetra()!=null && !ev.getLetra().trim().equals(""))
					|| (ev.getCodmun()!=null && !ev.getCodmun().trim().equals(""))
					|| (ev.getLocali()!=null && !ev.getLocali().trim().equals(""))
					|| (ev.getCodpro()!=null && !ev.getCodpro().trim().equals(""))
					|| (ev.getCodpst()!=null && !ev.getCodpst().trim().equals(""))
					|| (ev.getClavecat()!=null && !ev.getClavecat().trim().equals(""))
					|| (ev.getFhInscrip()!=null && !ev.getFhInscrip().trim().equals(""))){
				if (ev.getCif()==null || ev.getCif().trim().equals("")){
					if (ev.getAprobado()!=0){
						errors=this.insertaError(errors, res.get("pantallas.literal.entidadesVinculadas") + " - " + res.get("pantallas.literal.nifCif"),P06BErrores.P06B_ERROR_0015);
						valida1=false;						
					}
				}
			}
			z++;
		}
		
		//Valida que el campo Identificador(CIF/NIF) no est repetido
		z = 0;
		ev = null;
		valida1 = true;
		i = 0;
		P06B61T00Datatype ev2 = null;
		while (valida1 && z<numEVs){
			i = 0;
			ev = (P06B61T00Datatype)objListas.getListaEVs().get(z);
			while (valida1 && i<numEVs){
				if (i!=z){
					ev2 = (P06B61T00Datatype)objListas.getListaEVs().get(i);
					if (ev.getCif()!=null && !ev.getCif().trim().equals("") && ev2.getCif()!=null && !ev2.getCif().trim().equals("") && ev.getCif().trim().equals(ev2.getCif().trim())){
						errors=this.insertaError(errors, res.get("pantallas.literal.entidadesVinculadas") + " - " + res.get("pantallas.literal.ev.cif"),P06BErrores.P06B_ERROR_0016);
						valida1=false;
					}
				}				
				i++;
			}
			z++;
		}

		//Valida que si se ha introducido algun dato en alguna fila, se obligue a introducir la clave del catlogo si se pone en estado ALTA.		
		z = 0;
		ev = null;
		valida1 = true;
		while (valida1 && z<numEVs){
			ev = (P06B61T00Datatype)objListas.getListaEVs().get(z);
			if ((ev.getEntidad()!=null && !ev.getEntidad().trim().equals(""))
					|| (ev.getCalle()!=null && !ev.getCalle().trim().equals(""))
					|| (ev.getPortal()!=null && !ev.getPortal().trim().equals(""))
					|| (ev.getPiso()!=null && !ev.getPiso().trim().equals(""))
					|| (ev.getLetra()!=null && !ev.getLetra().trim().equals(""))
					|| (ev.getCodmun()!=null && !ev.getCodmun().trim().equals(""))
					|| (ev.getLocali()!=null && !ev.getLocali().trim().equals(""))
					|| (ev.getCodpro()!=null && !ev.getCodpro().trim().equals(""))
					|| (ev.getCodpst()!=null && !ev.getCodpst().trim().equals(""))
					|| (ev.getClavecat()!=null && !ev.getClavecat().trim().equals(""))
					|| (ev.getFhInscrip()!=null && !ev.getFhInscrip().trim().equals(""))){
				if ((ev.getClavecat()==null || ev.getClavecat().trim().equals("")) && P06BConstantes.P06B_CORREDORES_ESTADO_ALTA.equals(request.getParameter("Estado"))){
					errors=this.insertaError(errors, res.get("pantallas.literal.entidadesVinculadas") + " - " + res.get("pantallas.literal.ev.clavecat"),P06BErrores.P06B_ERROR_0023);
					valida1=false;
				}
			}
			z++;
		}
		
		//FIN PESTAA 12 - EMPRESAS VINCULADAS
		
		
		//PESTAA 13 - CAPACIDAD FINANCIERA
		//Campo N Participaciones-> Entero
		//Fecha alta -> Obligatoria y Fecha valida
		if (request.getParameter("CapacidadFinanciera")!=null){
			if (Byte.parseByte(request.getParameter("CapacidadFinanciera"))==P06BConstantes.P06B_CF_DEBECUMPLIMENTAR){
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.capacidadFinanciera") + " - " + res.get("pantallas.literal.CapacidadFinanciera.impFondos"),request.getParameter("impFondos"),idioma);
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.OBLIGATORIO,res.get("pantallas.literal.capacidadFinanciera") + " - " + res.get("pantallas.literal.CapacidadFinanciera.impCapacidad"),request.getParameter("impCapacidad"),idioma);
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.capacidadFinanciera") + " - " + res.get("pantallas.literal.CapacidadFinanciera.impFondos"),request.getParameter("impFondos"),idioma);
				errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.capacidadFinanciera") + " - " + res.get("pantallas.literal.CapacidadFinanciera.impCapacidad"),request.getParameter("impCapacidad"),idioma);
			}			
		}

		//FIN PESTAA 13 - CAPACIDAD FINANCIERA
		
		//Comprobamos que haya algn error
		if(!errors.isEmpty())
			resultado = false;
		request.setAttribute("errors",errors);
		return resultado;
	}
	
	//Modificamos el Corredor en la BD 
	//Devolvemos el numero expediente que le hemos asignado
	private String update(HttpServletRequest request, HttpServletResponse response) throws P06BException{
		String result = "";
		try{
			
			
			P06B20T00Datatype obj = new P06B20T00Datatype();
			
			obj.setExpedi((request.getParameter("Expedi")==null)?"":request.getParameter("Expedi"));
			obj.setClase((request.getParameter("Clase")==null)?"":request.getParameter("Clase"));
			obj.setDni((request.getParameter("DNI")==null)?"":request.getParameter("DNI"));
			obj.setRazsoc((request.getParameter("RazSoc")==null)?"":request.getParameter("RazSoc"));
			obj.setNombre((request.getParameter("Nombre")==null)?"":request.getParameter("Nombre"));
			obj.setApe1((request.getParameter("Ape1")==null)?"":request.getParameter("Ape1"));
			obj.setApe2((request.getParameter("Ape2")==null)?"":request.getParameter("Ape2"));
			
			obj.setCodpro((request.getParameter("CodPro")==null)?"":request.getParameter("CodPro"));
			obj.setCodmun((request.getParameter("CodMun")==null)?"":request.getParameter("CodMun"));
			obj.setLocali((request.getParameter("CodLoc")==null)?"":request.getParameter("CodLoc"));
			obj.setCodpst((request.getParameter("CodPst")==null)?"":request.getParameter("CodPst"));
			obj.setDomici((request.getParameter("Domici")==null)?"":request.getParameter("Domici"));
			
			obj.setTelefot((request.getParameter("Telefot")==null)?"":request.getParameter("Telefot"));
			obj.setTelefom((request.getParameter("Telefom")==null)?"":request.getParameter("Telefom"));
			obj.setTelefoc((request.getParameter("Telefoc")==null)?"":request.getParameter("Telefoc"));
			obj.setFax1((request.getParameter("Fax1")==null)?"":request.getParameter("Fax1"));
			obj.setFax2((request.getParameter("Fax2")==null)?"":request.getParameter("Fax2"));
			obj.setMail((request.getParameter("Mail")==null)?"":request.getParameter("Mail"));
			obj.setWeb((request.getParameter("Web")==null)?"":request.getParameter("Web"));
			obj.setCurso((request.getParameter("Curso")==null)?"":request.getParameter("Curso"));
			obj.setDenCurso((request.getParameter("DenCurso")==null)?"":request.getParameter("DenCurso"));
			obj.setAcredita((request.getParameter("Acredita")==null)?"":request.getParameter("Acredita"));
			obj.setDAcredita((request.getParameter("DAcredita")==null)?"":request.getParameter("DAcredita"));			
			obj.setEstado((request.getParameter("Estado")==null)?"":request.getParameter("Estado"));
			
			//Cuidado con las fechas y el idioma...Debera normalizar la fecha en el caso del euskera
			String idioma = this.getIdioma(request,response);
			
			String fechaAl = (request.getParameter("FechaAl")==null)?"":request.getParameter("FechaAl");
 			if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU))
 				fechaAl = P06BFecha.fechaFromFechaEu(fechaAl);
 			obj.setFechaAl(fechaAl);
 			
			String fechaB = (request.getParameter("FechaBaj")==null)?"":request.getParameter("FechaBaj");
 			if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU))
 				fechaB = P06BFecha.fechaFromFechaEu(fechaB);
			obj.setFechaBaj(fechaB);
			obj.setMotivoB((request.getParameter("MotivoB")==null)?"":request.getParameter("MotivoB"));
			
			String fechaSus = (request.getParameter("FechaSus")==null)?"":request.getParameter("FechaSus");
 			if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU))
 				fechaSus = P06BFecha.fechaFromFechaEu(fechaSus);
			obj.setFechaSus(fechaSus);
			
			obj.setMotivoS((request.getParameter("MotivoS")==null)?"":request.getParameter("MotivoS"));
			
			String fecFinSu = (request.getParameter("FecFinSu")==null)?"":request.getParameter("FecFinSu");
 			if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU))
 				fecFinSu = P06BFecha.fechaFromFechaEu(fecFinSu);
			obj.setFecFinSu(fecFinSu);			
			
			obj.setCapsoc((request.getParameter("Capsoc")==null)?"":request.getParameter("Capsoc").replaceAll("\\.","").replaceAll(",","."));
			obj.setPaticipa((request.getParameter("Paticipa")==null)?"":request.getParameter("Paticipa").replaceAll("\\.",""));
			
			obj.setDProFor((request.getParameter("DProFor")==null)?"":request.getParameter("DProFor"));
			obj.setActIns((request.getParameter("ActIns")==null)?"":request.getParameter("ActIns"));
						
			String trasdgs = (request.getParameter("Trasdgs")==null)?"":request.getParameter("Trasdgs");
 			if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU))
 				trasdgs = P06BFecha.fechaFromFechaEu(trasdgs);
			obj.setTrasdgs(trasdgs);

			P06B60T00Datatype datosCapacidadFinanciera = new P06B60T00Datatype();
			
			datosCapacidadFinanciera.setnExpediente(obj.getExpedi());

			if (request.getParameter("CapacidadFinanciera")!= null){
				datosCapacidadFinanciera.setnExpediente(obj.getExpedi());
				byte declaro = Byte.parseByte(request.getParameter("CapacidadFinanciera"));
				datosCapacidadFinanciera.setcFDeclaro(declaro);
//				try{
//					datosCapacidadFinanciera.setcFImpFondos(Integer.parseInt(request.getParameter("impFondos")));
//				}catch(NumberFormatException nfe){
//					datosCapacidadFinanciera.setcFImpFondos(-1);
//				}
				datosCapacidadFinanciera.setcFImpFondos((request.getParameter("impFondos")==null)?"":request.getParameter("impFondos"));
//				try{
//					datosCapacidadFinanciera.setcFImpCapacidad(Integer.parseInt(request.getParameter("impCapacidad")));
//				}catch(NumberFormatException nfe){
//					datosCapacidadFinanciera.setcFImpCapacidad(-1);
//				}
				datosCapacidadFinanciera.setcFImpCapacidad((request.getParameter("impCapacidad")==null)?"":request.getParameter("impCapacidad"));
				
				boolean bContrataSeguro = false;
				if (request.getParameter("contrataSeguro")!=null){
					bContrataSeguro = true;
				}
				datosCapacidadFinanciera.setcFContrataSeguro(bContrataSeguro);
				datosCapacidadFinanciera.setcFTextoSeguro(request.getParameter("textoSeguro"));
				
				boolean bContrataAval = false;
				if (request.getParameter("contrataAval")!=null){
					bContrataAval = true;
				}
				datosCapacidadFinanciera.setcFContrataAval(bContrataAval);
				datosCapacidadFinanciera.setcFTextoAval(request.getParameter("textoAval"));

			}
			obj.setDatosCapacidadFinanciera(datosCapacidadFinanciera);
			
			P06B64T00Datatype datosAtencionPeticionEnRevision = null;
			int nCorrelAtencionPeticionEnRevision = -1;
			
			boolean bCargaIncorporarDEC = false;
			boolean bCargaIncorporarModTramitagune = false;
			String sObjetivo = (String)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"objetivo"+P06BConstantes.P06B_VAR_TEMP_FILTRO);
	        if (sObjetivo!= null){
	        	if (sObjetivo.equals(((Integer)P06BConstantes.P06B_BUSQCORR_TRAMITEPENDIENTE_INCORPORARDEC).toString())){
		        	bCargaIncorporarDEC = true;	        		
	        	}else if (sObjetivo.equals(((Integer)P06BConstantes.P06B_BUSQCORR_TRAMITEPENDIENTE_INCORPORARMODTRAMITAGUNE).toString())){
	        		nCorrelAtencionPeticionEnRevision = P06BCorredoresManager.getInstance().selectCorrelAtencionPeticionEnRevision(obj.getExpedi());
        			datosAtencionPeticionEnRevision = P06BCorredoresManager.getInstance().selectDatosAtencPeticTramitagune(nCorrelAtencionPeticionEnRevision);
	        		bCargaIncorporarModTramitagune = true;	        		
	        	}
	        }else{
				P06B64T00Datatype datosAtencionPeticionEnRevisionAux = null;
        		datosAtencionPeticionEnRevisionAux = (P06B64T00Datatype)request.getSession().getAttribute("AtencionPeticionEnRevision");
        		if (datosAtencionPeticionEnRevisionAux != null){
	        		if (datosAtencionPeticionEnRevisionAux.getProcedimiento().equals(P06BParametros.get("idProcModRegMedSeg"))){
	        			if (datosAtencionPeticionEnRevisionAux.getEstado()==P06BConstantes.P06B_AP_ESTADO_PORREVISAR){
	    	        		nCorrelAtencionPeticionEnRevision = datosAtencionPeticionEnRevisionAux.getCorrelativo();
	            			datosAtencionPeticionEnRevision = datosAtencionPeticionEnRevisionAux;
				        	bCargaIncorporarModTramitagune = true;		        				
	        			}
	        		}	        			
        		}
        	}

	        if (request.getParameter("subaccion")!=null){
				obj.setEstadoAceptarPropuestas(Byte.parseByte(request.getParameter("subaccion")));
			}else{
				obj.setEstadoAceptarPropuestas(P06BConstantes.P06B_AP_ESTADO_ENSISTEMA);
			}
			int nEjerIncorporarDEC = -1;
	        if (bCargaIncorporarDEC){
	        	nEjerIncorporarDEC = P06BCorredoresManager.getInstance().selectEjercicioIncorporarDEC(obj.getExpedi());
			}else if(bCargaIncorporarModTramitagune){
			}else{
				int ultEjerIncorporado = 0;
				if (request.getParameter("ultEjerDECIncorporado")!=null){
					try{
					ultEjerIncorporado = Integer.parseInt(request.getParameter("ultEjerDECIncorporado"));
					}catch(NumberFormatException nfe){
						
					}
				}
				obj.setUltEjerIncorporado(ultEjerIncorporado);

			
				int ultAtencPeticIncorporada = 0;
				if (request.getParameter("ultAtencPeticIncorporada")!=null){
					try{
						ultAtencPeticIncorporada = Integer.parseInt(request.getParameter("ultAtencPeticIncorporada"));				
					}catch(NumberFormatException nfe){
						
					}
					
				}
				obj.setUltAtencPeticIncorporada(ultAtencPeticIncorporada);

				
			
			}
			obj.setDatosAtencionPeticionEnRevision(datosAtencionPeticionEnRevision);
        	obj.setEjerDECAIncorporar(nEjerIncorporarDEC);
			obj.setCorrelAtencionPeticionEnRevision(nCorrelAtencionPeticionEnRevision);
			
			if (request.getParameter("DefensaAtencionCliente")!=null){
				obj.setTipoAtencionCliente(request.getParameter("DefensaAtencionCliente"));
			}else{
				obj.setTipoAtencionCliente(null);				
			}
			
			P06BCorredor corredor = new P06BCorredor();
			corredor.setDatosCorredor(obj);
			P06BCorredorListasAux listas = new P06BCorredorListasAux();
			if(request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux")!=null){
				listas = (P06BCorredorListasAux)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"CorredorListasAux");
			}
			
			//Pongo las fechas de los objetos de las listas OK
			//Pongo los campos numricos con el formato correcto
			//Verifico que aquellos socios donde todos los campos sean vacos, no se guarden
			
			//SOCIOS
			P06B22T00Datatype socio = null;
			int numSoc = 0;
			int sizeListaSoc = listas.getListaSocios().size();
			for(int i=0;i<sizeListaSoc;i++){
				socio = (P06B22T00Datatype)listas.getListaSocios().get(numSoc);
				if(socio.isEmpty()){
					listas.getListaSocios().remove(numSoc);
				}else{
					socio.setParticipa(socio.getParticipa().replaceAll("\\.","").replaceAll(",","."));
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						socio.setFecAlta(P06BFecha.fechaFromFechaEu(socio.getFecAlta()));
						socio.setFecBaja(P06BFecha.fechaFromFechaEu(socio.getFecBaja()));
					}
					numSoc++;
				}
			}
			//Fin SOCIOS
			
			//SOCIOS INDIRECTOS
			socio = null;
			numSoc = 0;
			int sizeListaSocIndirec = listas.getListaSociosIndirec().size();
			for(int i=0;i<sizeListaSocIndirec;i++){
				socio = (P06B22T00Datatype)listas.getListaSociosIndirec().get(numSoc);		
				if(socio.isEmpty()){
					listas.getListaSociosIndirec().remove(numSoc);
				}else{
					socio.setParticipa(socio.getParticipa().replaceAll("\\.","").replaceAll(",","."));
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						socio.setFecAlta(P06BFecha.fechaFromFechaEu(socio.getFecAlta()));
						socio.setFecBaja(P06BFecha.fechaFromFechaEu(socio.getFecBaja()));
					}
					numSoc++;
				}
			}
			//Fin SOCIOS INDIRECTOS
			
			//AUXILIARES EXTERNOS
			socio = null;
			numSoc = 0;
			int sizeListaAuxExterno = listas.getListaAuxExternos().size();
			for(int i=0;i<sizeListaAuxExterno;i++){
				socio = (P06B22T00Datatype)listas.getListaAuxExternos().get(numSoc);		
				if(socio.isEmpty()){
					listas.getListaAuxExternos().remove(numSoc);
				}else{
					socio.setParticipa(socio.getParticipa().replaceAll("\\.","").replaceAll(",","."));
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						socio.setFecAlta(P06BFecha.fechaFromFechaEu(socio.getFecAlta()));
						socio.setFecBaja(P06BFecha.fechaFromFechaEu(socio.getFecBaja()));
					}
					numSoc++;
				}
			}
			//Fin AUXILIARES EXTERNOS
			
			//ORGANOS
			P06B24T00Datatype organo = null;
			int numOrganos = 0;
			int sizeListaOrg = listas.getListaOrganos().size();
			for(int i=0;i<sizeListaOrg;i++){
				organo = (P06B24T00Datatype)listas.getListaOrganos().get(numOrganos);		
				if(organo.isEmpty()){
					listas.getListaOrganos().remove(numOrganos);
				}else{
					//Fechas
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						organo.setFechNom(P06BFecha.fechaFromFechaEu(organo.getFechNom()));
						organo.setFecSus(P06BFecha.fechaFromFechaEu(organo.getFecSus()));
						organo.setFecLeSus(P06BFecha.fechaFromFechaEu(organo.getFecLeSus()));
						organo.setFecRev(P06BFecha.fechaFromFechaEu(organo.getFecRev()));
						organo.setFecInha(P06BFecha.fechaFromFechaEu(organo.getFecInha()));
						organo.setFecCese(P06BFecha.fechaFromFechaEu(organo.getFecCese()));
					}
					
					//Duracion inhablitacion, en meses, es un entero
					organo.setDurHab(organo.getDurHab().replaceAll("\\.",""));
										
					numOrganos++;
				}
			}
			//Fin ORGANOS
			
			//DIRECCION TECNICA
			organo = null;
			numOrganos = 0;
			sizeListaOrg = listas.getListaDirecTec().size();
			for(int i=0;i<sizeListaOrg;i++){
				organo = (P06B24T00Datatype)listas.getListaDirecTec().get(numOrganos);		
				if(organo.isEmpty()){
					listas.getListaDirecTec().remove(numOrganos);
				}else{
					//Fechas
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						organo.setFechNom(P06BFecha.fechaFromFechaEu(organo.getFechNom()));
						organo.setFecSus(P06BFecha.fechaFromFechaEu(organo.getFecSus()));
						organo.setFecLeSus(P06BFecha.fechaFromFechaEu(organo.getFecLeSus()));
						organo.setFecRev(P06BFecha.fechaFromFechaEu(organo.getFecRev()));
						organo.setFecInha(P06BFecha.fechaFromFechaEu(organo.getFecInha()));
						organo.setFecCese(P06BFecha.fechaFromFechaEu(organo.getFecCese()));
					}
					
					//Duracion inhablitacion, en meses, es un entero
					organo.setDurHab(organo.getDurHab().replaceAll("\\.",""));
										
					numOrganos++;
				}
			}
			//Fin DIRECCION TECNICA
			
			//OTROS DIRECCION
			organo = null;
			numOrganos = 0;
			sizeListaOrg = listas.getListaOtrosDirec().size();
			for(int i=0;i<sizeListaOrg;i++){
				organo = (P06B24T00Datatype)listas.getListaOtrosDirec().get(numOrganos);		
				if(organo.isEmpty()){
					listas.getListaOtrosDirec().remove(numOrganos);
				}else{
					//Fechas
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						organo.setFechNom(P06BFecha.fechaFromFechaEu(organo.getFechNom()));
						organo.setFecSus(P06BFecha.fechaFromFechaEu(organo.getFecSus()));
						organo.setFecLeSus(P06BFecha.fechaFromFechaEu(organo.getFecLeSus()));
						organo.setFecRev(P06BFecha.fechaFromFechaEu(organo.getFecRev()));
						organo.setFecInha(P06BFecha.fechaFromFechaEu(organo.getFecInha()));
						organo.setFecCese(P06BFecha.fechaFromFechaEu(organo.getFecCese()));
					}
					
					//Duracion inhablitacion, en meses, es un entero
					organo.setDurHab(organo.getDurHab().replaceAll("\\.",""));
										
					numOrganos++;
				}
			}
			//Fin OTROS DIRECCION
			
			//ADMINISTRADORES
			organo = null;
			numOrganos = 0;
			sizeListaOrg = listas.getListaAdministradores().size();
			for(int i=0;i<sizeListaOrg;i++){
				organo = (P06B24T00Datatype)listas.getListaAdministradores().get(numOrganos);		
				if(organo.isEmpty()){
					listas.getListaAdministradores().remove(numOrganos);
				}else{
					//Fechas
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						organo.setFechNom(P06BFecha.fechaFromFechaEu(organo.getFechNom()));
						organo.setFecSus(P06BFecha.fechaFromFechaEu(organo.getFecSus()));
						organo.setFecLeSus(P06BFecha.fechaFromFechaEu(organo.getFecLeSus()));
						organo.setFecRev(P06BFecha.fechaFromFechaEu(organo.getFecRev()));
						organo.setFecInha(P06BFecha.fechaFromFechaEu(organo.getFecInha()));
						organo.setFecCese(P06BFecha.fechaFromFechaEu(organo.getFecCese()));
					}
					
					//Duracion inhablitacion, en meses, es un entero
					organo.setDurHab(organo.getDurHab().replaceAll("\\.",""));
										
					numOrganos++;
				}
			}
			//Fin ADMINISTRADORES
			
			
			//SUCURSALES
			P06B25T00Datatype sucursal = null;
			int numSucursales = 0;
			int sizeListaSuc = listas.getListaSucursales().size();
			for(int i=0;i<sizeListaSuc;i++){
				sucursal = (P06B25T00Datatype)listas.getListaSucursales().get(numSucursales);		
				if(sucursal.isEmpty()){
					listas.getListaSucursales().remove(numSucursales);
				}else{										
					numSucursales++;
				}
			}
			//Fin SUCURSALES
			
			
			//DEFENSORES CLIENTE
			P06B29T00Datatype defCliente = null;
			P06B30T00Datatype defPFCliente = null;
			int numDefCliente = 0;
			int numPFDefCliente = 0;
			int sizeListaPFDefCliente = 0;
			int sizeListaDefCliente = listas.getListaDefCliente().size();
			for(int i=0;i<sizeListaDefCliente;i++){
				defCliente = (P06B29T00Datatype)listas.getListaDefCliente().get(numDefCliente);		
				if(defCliente.isEmpty()){
					listas.getListaDefCliente().remove(numDefCliente);
				}else{
					//Comprobar si la lista de personas fsicas del defensor de cliente tiene registros vacios
					defPFCliente = null;
					numPFDefCliente = 0;
					if(defCliente.getListaPF_DefCliente() != null && defCliente.getListaPF_DefCliente().size() > 0){
						sizeListaPFDefCliente = defCliente.getListaPF_DefCliente().size();
						for(int j=0;j<sizeListaPFDefCliente;j++){
							defPFCliente = (P06B30T00Datatype)defCliente.getListaPF_DefCliente().get(numPFDefCliente);		
							if(defPFCliente.isEmpty()){
								((P06B29T00Datatype)listas.getListaDefCliente().get(numDefCliente)).getListaPF_DefCliente().remove(numPFDefCliente);
							}else{
								numPFDefCliente++;
							}
						}
					}
					
					numDefCliente++;
				}
			}
			//Fin DEFENSORES CLIENTE
			
			
			//DEPARTAMENTO de ATENCION al CLIENTE
			P06B26T00Datatype depAtCliente = null;
			P06B27T00Datatype depAtPFCliente = null;
			P06B28T00Datatype depAtRespCliente = null;
			int numDepAtCliente = 0;
			int numPFDepAtCliente = 0;
			int numRespDepAtCliente = 0;
			int sizeListaPFDepAtCliente = 0;
			int sizeListaRespDepAtCliente = 0;
			int sizeListaDepAtCliente = listas.getListaDepAtCliente().size();
			for(int i=0;i<sizeListaDepAtCliente;i++){
				depAtCliente = (P06B26T00Datatype)listas.getListaDepAtCliente().get(numDepAtCliente);		
				if(depAtCliente.isEmpty()){
					listas.getListaDepAtCliente().remove(numDepAtCliente);
				}else{
					//Comprobar si la lista de personas fsicas del departamento de atencin al cliente tiene registros vacios
					depAtPFCliente = null;
					numPFDepAtCliente = 0;
					if(depAtCliente.getListaPF_DepAtCliente() != null && depAtCliente.getListaPF_DepAtCliente().size() > 0){
						sizeListaPFDepAtCliente = depAtCliente.getListaPF_DepAtCliente().size();
						for(int j=0;j<sizeListaPFDepAtCliente;j++){
							depAtPFCliente = (P06B27T00Datatype)depAtCliente.getListaPF_DepAtCliente().get(numPFDepAtCliente);		
							if(depAtPFCliente.isEmpty()){
								((P06B26T00Datatype)listas.getListaDepAtCliente().get(numDepAtCliente)).getListaPF_DepAtCliente().remove(numPFDepAtCliente);
							}else{
								numPFDepAtCliente++;
							}
						}
					}
					
					
					//Comprobar si la lista de responsables del departamento de atencin al cliente tiene registros vacios
					depAtRespCliente = null;
					numRespDepAtCliente = 0;
					if(depAtCliente.getListaRespDepAtCl() != null && depAtCliente.getListaRespDepAtCl().size() > 0){
						sizeListaRespDepAtCliente = depAtCliente.getListaRespDepAtCl().size();
						for(int j=0;j<sizeListaRespDepAtCliente;j++){
							depAtRespCliente = (P06B28T00Datatype)depAtCliente.getListaRespDepAtCl().get(numRespDepAtCliente);		
							if(depAtRespCliente.isEmpty()){
								((P06B26T00Datatype)listas.getListaDepAtCliente().get(numDepAtCliente)).getListaRespDepAtCl().remove(numRespDepAtCliente);
							}else{
								numRespDepAtCliente++;
							}
						}
					}
					
					
					numDepAtCliente++;
				}
			}
			//Fin DEPARTAMENTO de ATENCION al CLIENTE
			
			
			corredor.setListas(listas);
			Context context =new InitialContext();
			Object objRef = context.lookup(P06BParametros.get("mediadoresSeguros.ejb.jndiName"));
			P06BMediadoresSegurosEJBHome home = (P06BMediadoresSegurosEJBHome)javax.rmi.PortableRemoteObject.narrow(
	                		  objRef, P06BMediadoresSegurosEJBHome.class);
			P06BMediadoresSegurosEJB mediadoresSeguroEJB = home.create();
			result=mediadoresSeguroEJB.updateCorredor(corredor);
		}catch (P06BException e){
	      	throw e;
	    }catch (Exception e){
	    	throw new P06BException(new Exception("Error Actualizacin BD"),P06BErrores.P06B_ERROR_0009);
	    }
	    return result;
	}
	
	
	private ArrayList insertaError(ArrayList errors, String nombreCampo, String codigo) {
	 	P06BError error = new P06BError();
		error.setNombreCampo(nombreCampo);
		error.setCodigo(codigo);
		errors.add(error);
		return errors;
   	}
	
}